/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.jackson.customtyping;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import de.fraunhofer.iosb.ilt.swe.common.AbstractSWEIdentifiable;
import de.fraunhofer.iosb.ilt.swe.common.constraint.AbstractConstraint;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SweTypeIdResolver
implements TypeIdResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SweTypeIdResolver.class.getName());
    private static final Map<String, Class<?>> annnotatedClasses;
    private JavaType superType;

    @Override
    public void init(JavaType baseType) {
        this.superType = baseType;
    }

    @Override
    public String idFromValue(Object value) {
        return SweTypeIdResolver.idFromClass(value.getClass());
    }

    public static String idFromClass(Class clazz) {
        String className = clazz.getName();
        String name = className.substring(1 + className.lastIndexOf(46));
        try {
            name = FieldUtils.readStaticField(clazz, "SWE_NAME").toString();
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException ex2) {
            LOGGER.trace("Class {} has no SWE_NAME field.", (Object)className);
        }
        LOGGER.trace("{} -> {}", (Object)clazz.getName(), (Object)name);
        return name;
    }

    @Override
    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return SweTypeIdResolver.idFromClass(value.getClass());
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id2) throws IOException {
        if (!annnotatedClasses.containsKey(id2)) {
            throw new RuntimeException(String.format("unkown type '%s'", id2));
        }
        return context.constructSpecializedType(this.superType, annnotatedClasses.get(id2));
    }

    @Override
    public String idFromBaseType() {
        return SweTypeIdResolver.idFromClass(this.superType.getRawClass());
    }

    @Override
    public String getDescForKnownTypeIds() {
        return annnotatedClasses.toString();
    }

    static {
        Reflections reflections = new Reflections("de.fraunhofer.iosb.ilt.swe.common", new Scanner[0]);
        annnotatedClasses = reflections.getSubTypesOf(AbstractSWEIdentifiable.class).stream().collect(Collectors.toMap(x2 -> SweTypeIdResolver.idFromClass(x2), x2 -> x2));
        annnotatedClasses.putAll(reflections.getSubTypesOf(AbstractConstraint.class).stream().collect(Collectors.toMap(x2 -> SweTypeIdResolver.idFromClass(x2), x2 -> x2)));
    }
}

