/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.dao;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.sta.MqttException;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.Utils;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.jackson.ObjectMapperFactory;
import de.fraunhofer.iosb.ilt.sta.model.Id;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ext.DataArrayDocument;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservationDao
extends BaseDao<Observation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObservationDao.class);
    public static final TypeReference<List<String>> LIST_OF_STRING = new TypeReference<List<String>>(){};

    public ObservationDao(SensorThingsService service) {
        super(service, Observation.class);
    }

    @Override
    public void create(Observation entity) throws ServiceFailureException {
        if (!entity.isResultSet()) {
            throw new IllegalArgumentException("Result must be set on Observation.");
        }
        super.create(entity);
    }

    public void createMqtt(Observation entity) throws MqttException {
        if (!entity.isResultSet()) {
            throw new IllegalArgumentException("Result must be set on Observation.");
        }
        this.getService().publish(this.getMqttTopic(), entity);
    }

    public List<String> create(DataArrayDocument dataArray) throws ServiceFailureException {
        HttpPost httpPost;
        String json;
        List<Object> result = new ArrayList();
        ObjectMapper mapper = ObjectMapperFactory.get();
        try {
            json = mapper.writeValueAsString(dataArray.getValue());
            URIBuilder uriBuilder = new URIBuilder(this.getService().getEndpoint() + "CreateObservations");
            httpPost = new HttpPost(uriBuilder.build());
        }
        catch (JsonProcessingException | URISyntaxException ex2) {
            throw new ServiceFailureException("Failed to create Observations.", ex2);
        }
        LOGGER.debug("Posting to: {}", (Object)httpPost.getURI());
        httpPost.setEntity(new StringEntity(json, ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse response = this.getService().execute(httpPost);){
            Utils.throwIfNotOk(httpPost, response);
            String jsonResponse = EntityUtils.toString(response.getEntity(), Consts.UTF_8);
            result = mapper.readValue(jsonResponse, LIST_OF_STRING);
            List<Observation> observations = dataArray.getObservations();
            if (observations.size() != result.size()) {
                LOGGER.error("Size of returned location list ({}) is not equal to number of sent Observations ({})!", (Object)result.size(), (Object)observations.size());
            }
            int i2 = 0;
            for (Observation o2 : observations) {
                String newLocation = (String)result.get(i2);
                if (newLocation.startsWith("error")) {
                    LOGGER.warn("Failed to insert Observation. Error: {}.", (Object)newLocation);
                } else {
                    int pos1 = newLocation.indexOf(40) + 1;
                    int pos2 = newLocation.indexOf(41, pos1);
                    String stringId = newLocation.substring(pos1, pos2);
                    o2.setId(Id.tryToParse(stringId));
                    o2.setService(this.getService());
                }
                ++i2;
            }
        }
        catch (IOException exc) {
            throw new ServiceFailureException("Failed to create Observations.", exc);
        }
        return result;
    }
}

