/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta;

import de.fraunhofer.iosb.ilt.sta.NotAuthorizedException;
import de.fraunhofer.iosb.ilt.sta.NotFoundException;
import de.fraunhofer.iosb.ilt.sta.StatusCodeException;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    public static String cleanForLogging(String string) {
        return StringUtils.replaceChars(string, "\n\r\t", "");
    }

    public static String cleanForLogging(String string, int maxLength) {
        return StringUtils.replaceChars(StringUtils.abbreviate(string, maxLength), "\n\r\t", "");
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String escapeForStringConstant(String in2) {
        return in2.replaceAll("'", "''");
    }

    public static String quoteForUrl(Object in2) {
        if (in2 instanceof Number) {
            return in2.toString();
        }
        return "'" + Utils.escapeForStringConstant(in2.toString()) + "'";
    }

    public static String urlEncode(String string, boolean notSlashes) {
        if (notSlashes) {
            return Utils.urlEncodeNotSlashes(string);
        }
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex2) {
            LOGGER.error("Should not happen, UTF-8 should always be supported.", ex2);
            return string;
        }
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex2) {
            LOGGER.error("Should not happen, UTF-8 should always be supported.", ex2);
            return string;
        }
    }

    public static String urlEncodeNotSlashes(String string) {
        try {
            CharSequence[] split = string.split("/");
            for (int i2 = 0; i2 < split.length; ++i2) {
                split[i2] = URLEncoder.encode((String)split[i2], StandardCharsets.UTF_8.name());
            }
            return String.join((CharSequence)"/", split);
        }
        catch (UnsupportedEncodingException ex2) {
            LOGGER.error("Should not happen, UTF-8 should always be supported.", ex2);
            return string;
        }
    }

    public static void throwIfNotOk(HttpRequestBase request, CloseableHttpResponse response) throws StatusCodeException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode < 200 || statusCode >= 300) {
            String returnContent = null;
            try {
                returnContent = EntityUtils.toString(response.getEntity(), Consts.UTF_8);
            }
            catch (IOException exc) {
                LOGGER.warn("Failed to get content from error response.", exc);
            }
            if (statusCode == 401 || statusCode == 403) {
                request.getURI();
                throw new NotAuthorizedException(request.getURI().toString(), response.getStatusLine().getReasonPhrase(), returnContent);
            }
            if (statusCode == 404) {
                throw new NotFoundException(request.getURI().toString(), response.getStatusLine().getReasonPhrase(), returnContent);
            }
            throw new StatusCodeException(request.getURI().toString(), statusCode, response.getStatusLine().getReasonPhrase(), returnContent);
        }
    }

    public static void createInsecureHttpClient(SensorThingsService service) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(new TrustSelfSignedStrategy()).build();
        NoopHostnameVerifier allowAllHosts = new NoopHostnameVerifier();
        SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)allowAllHosts);
        service.getClientBuilder().setSSLSocketFactory(connectionFactory);
        service.rebuildHttpClient();
    }
}

