/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.settings;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsMigrator.class.getName());
    private final Map<String, Map<String, ReplaceList>> valueChanges = new HashMap<String, Map<String, ReplaceList>>();
    private final Map<String, String> keyChanges = new HashMap<String, String>();

    private Map<String, ReplaceList> getReplaceValue(String key) {
        return this.valueChanges.computeIfAbsent(key, t2 -> new TreeMap());
    }

    public SettingsMigrator() {
        String valuePpm = "de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.PostgresPersistenceManager";
        String keyCoreModelidType = "plugins.coreModel.idType";
        String keyPersistenceImpCls = "persistence.persistenceManagerImplementationClass";
        ReplaceList ppm = ReplaceList.make().put("persistence.persistenceManagerImplementationClass", valuePpm);
        ReplaceList ppmLong = ppm.copy().put("plugins.coreModel.idType", "LONG");
        ReplaceList ppmStrg = ppm.copy().put("plugins.coreModel.idType", "STRING");
        ReplaceList ppmUuid = ppm.copy().put("plugins.coreModel.idType", "UUID");
        Map<String, ReplaceList> pmc = this.getReplaceValue("persistence.persistenceManagerImplementationClass");
        pmc.put("de.fraunhofer.iosb.ilt.sta.persistence.postgres.PostgresPersistenceManager", ppmLong);
        pmc.put("de.fraunhofer.iosb.ilt.sta.persistence.postgres.longid.PostgresPersistenceManagerLong", ppmLong);
        pmc.put("de.fraunhofer.iosb.ilt.sta.persistence.postgres.stringid.PostgresPersistenceManagerString", ppmStrg);
        pmc.put("de.fraunhofer.iosb.ilt.sta.persistence.postgres.uuidid.PostgresPersistenceManagerUuid", ppmUuid);
        pmc.put("de.fraunhofer.iosb.ilt.sta.persistence.pgjooq.imp.PostgresPersistenceManagerLong", ppmLong);
        pmc.put("de.fraunhofer.iosb.ilt.sta.persistence.pgjooq.imp.PostgresPersistenceManagerString", ppmStrg);
        pmc.put("de.fraunhofer.iosb.ilt.sta.persistence.pgjooq.imp.PostgresPersistenceManagerUuid", ppmUuid);
        pmc.put("de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.imp.PostgresPersistenceManagerLong", ppmLong);
        pmc.put("de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.imp.PostgresPersistenceManagerString", ppmStrg);
        pmc.put("de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.imp.PostgresPersistenceManagerUuid", ppmUuid);
        this.keyChanges.put("enableActuation", "plugins.actuation.enable");
        this.keyChanges.put("enableMultiDatastream", "plugins.multiDatastream.enable");
        this.keyChanges.put("persistence.alwaysOrderbyId", "alwaysOrderbyId");
    }

    public void migrateOldSettings(Properties properties) {
        for (Map.Entry<String, String> entry : this.keyChanges.entrySet()) {
            this.migrateOldSettings(properties, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.valueChanges.entrySet()) {
            this.migrateOldSettings(properties, entry.getKey(), (Map)entry.getValue());
        }
    }

    private void migrateOldSettings(Properties properties, String key, Map<String, ReplaceList> replaces) {
        String oldValue = properties.getProperty(key);
        if (oldValue == null) {
            return;
        }
        ReplaceList newValues = replaces.get(oldValue);
        if (newValues != null) {
            LOGGER.warn("Converting settings of key '{}' with old value '{}'", (Object)key, (Object)oldValue);
            properties.remove(key);
            for (Map.Entry<String, String> entry : newValues.getItems().entrySet()) {
                String newKey = entry.getKey();
                String newVal = entry.getValue();
                LOGGER.warn("                Adding key '{}' : '{}'", (Object)newKey, (Object)newVal);
                properties.put(newKey, newVal);
            }
        }
    }

    private void migrateOldSettings(Properties properties, String oldKey, String newKey) {
        Object oldValue = properties.get(oldKey);
        if (oldValue != null) {
            LOGGER.warn("Converting setting with old key: {} to new key: {} with value: {}", oldKey, newKey, oldValue);
            properties.remove(oldKey);
            properties.put(newKey, oldValue);
        }
    }

    public static void migrate(Properties properties) {
        new SettingsMigrator().migrateOldSettings(properties);
    }

    private static class ReplaceList {
        private final Map<String, String> items = new HashMap<String, String>();

        private ReplaceList() {
        }

        static ReplaceList make() {
            return new ReplaceList();
        }

        public Map<String, String> getItems() {
            return this.items;
        }

        public ReplaceList put(String key, String value) {
            this.items.put(key, value);
            return this;
        }

        public ReplaceList copy() {
            ReplaceList copy = ReplaceList.make();
            copy.items.putAll(this.items);
            return copy;
        }
    }
}

