/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.query.expression.constant;

import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.Constant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.LineStringConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.PointConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.PolygonConstant;
import de.fraunhofer.iosb.ilt.frostserver.util.WktParser;
import java.util.Objects;
import org.geojson.GeoJsonObject;
import org.geojson.LineString;
import org.geojson.Point;
import org.geojson.Polygon;

public abstract class GeoJsonConstant<T extends GeoJsonObject>
extends Constant<T> {
    private String source;

    public static GeoJsonConstant<? extends GeoJsonObject> fromString(String value) {
        GeoJsonObject geoJsonObject = WktParser.parseWkt(value);
        if (geoJsonObject instanceof Point) {
            return new PointConstant((Point)geoJsonObject, value);
        }
        if (geoJsonObject instanceof LineString) {
            return new LineStringConstant((LineString)geoJsonObject, value);
        }
        if (geoJsonObject instanceof Polygon) {
            return new PolygonConstant((Polygon)geoJsonObject, value);
        }
        throw new IllegalArgumentException("unknown WKT string format '" + value + "'");
    }

    protected GeoJsonConstant(T value) {
        this(value, null);
    }

    protected GeoJsonConstant(T value, String source) {
        super(value);
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public String toUrl() {
        return "geography'" + this.source + "'";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoJsonConstant other = (GeoJsonConstant)obj;
        return Objects.equals(this.source, other.source);
    }
}

