/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property.type;

import com.fasterxml.jackson.core.type.TypeReference;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeSimple;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeSimplePrimitive;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeSimpleCustom
extends TypeSimple {
    public static final TypeSimpleCustom STA_GEOJSON = new TypeSimpleCustom("GeoJson", "A GeoJSON Object", TypeSimplePrimitive.EDM_GEOMETRY, null);
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeSimpleCustom.class.getName());
    private static final Map<String, TypeSimpleCustom> TYPES = new HashMap<String, TypeSimpleCustom>();

    public static TypeSimpleCustom getType(String name) {
        return TYPES.get(name);
    }

    public TypeSimpleCustom(String name, String description, TypeSimplePrimitive underlyingType) {
        super(name, description, underlyingType, underlyingType.getTypeReference());
    }

    public TypeSimpleCustom(String name, String description, TypeSimplePrimitive underlyingType, TypeReference typeReference) {
        super(name, description, underlyingType, typeReference);
    }

    static {
        for (Field field : FieldUtils.getAllFields(TypeSimpleCustom.class)) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                TypeSimpleCustom type = (TypeSimpleCustom)FieldUtils.readStaticField(field, false);
                String name = type.getName();
                TYPES.put(name, type);
                LOGGER.debug("Registered type: {}", (Object)name);
            }
            catch (IllegalArgumentException ex2) {
                LOGGER.error("Failed to initialise: {}", (Object)field, (Object)ex2);
            }
            catch (IllegalAccessException ex3) {
                LOGGER.trace("Failed to initialise: {}", (Object)field, (Object)ex3);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

