/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.property.type;

import com.fasterxml.jackson.core.type.TypeReference;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TypeReferencesHelper;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeSimplePrimitive;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeComplex
extends PropertyType {
    public static final String STA_MAP_NAME = "Object";
    public static final String STA_OBJECT_NAME = "ANY";
    public static final String KEY_INTERVAL_START = "start";
    public static final String KEY_INTERVAL_END = "end";
    public static final TypeComplex STA_MAP = new TypeComplex("Object", "A free object that can contain anything", TypeReferencesHelper.TYPE_REFERENCE_MAP, true);
    public static final TypeComplex STA_OBJECT = new TypeComplex("ANY", "A free type, can be anything", TypeReferencesHelper.TYPE_REFERENCE_OBJECT, true);
    public static final TypeComplex STA_OBJECT_UNTYPED = new TypeComplex("ANY", "A free type, can be anything", null, true);
    public static final TypeComplex STA_TIMEINTERVAL = new TypeComplex("TimeInterval", "An ISO time interval.", TypeReferencesHelper.TYPE_REFERENCE_TIMEINTERVAL).addProperty("start", TypeSimplePrimitive.EDM_DATETIMEOFFSET, true).addProperty("end", TypeSimplePrimitive.EDM_DATETIMEOFFSET, true);
    public static final TypeComplex STA_TIMEVALUE = new TypeComplex("TimeValue", "An ISO time instant or time interval.", TypeReferencesHelper.TYPE_REFERENCE_TIMEVALUE).addProperty("start", TypeSimplePrimitive.EDM_DATETIMEOFFSET, true).addProperty("end", TypeSimplePrimitive.EDM_DATETIMEOFFSET, false);
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeComplex.class.getName());
    private static final Map<String, TypeComplex> TYPES = new HashMap<String, TypeComplex>();
    private final boolean openType;
    private final Map<String, PropertyType> properties = new LinkedHashMap<String, PropertyType>();
    private final Map<String, Boolean> propertiesRequired = new LinkedHashMap<String, Boolean>();

    public static TypeComplex getType(String name) {
        return TYPES.get(name);
    }

    public TypeComplex(String name, String description, TypeReference typeReference) {
        this(name, description, typeReference, false);
    }

    public TypeComplex(String name, String description, TypeReference typeReference, boolean openType) {
        super(name, description, typeReference);
        this.openType = openType;
    }

    public boolean isOpenType() {
        return this.openType;
    }

    public Map<String, PropertyType> getProperties() {
        return this.properties;
    }

    public boolean isRequired(String property) {
        return this.propertiesRequired.getOrDefault(property, false);
    }

    public TypeComplex addProperty(String name, PropertyType property, boolean required) {
        this.properties.put(name, property);
        if (required) {
            this.propertiesRequired.put(name, required);
        }
        return this;
    }

    static {
        for (Field field : FieldUtils.getAllFields(TypeComplex.class)) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                TypeComplex type = (TypeComplex)FieldUtils.readStaticField(field, false);
                String name = type.getName();
                TYPES.put(name, type);
                LOGGER.debug("Registered type: {}", (Object)name);
            }
            catch (IllegalArgumentException ex2) {
                LOGGER.error("Failed to initialise: {}", (Object)field, (Object)ex2);
            }
            catch (IllegalAccessException ex3) {
                LOGGER.trace("Failed to initialise: {}", (Object)field, (Object)ex3);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

