/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils;

import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValue;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDriver;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionUtils
implements ConfigDefaults {
    @DefaultValue(value="")
    public static final String TAG_DATA_SOURCE = "db.jndi.datasource";
    @DefaultValue(value="")
    public static final String TAG_DB_DRIVER = "db.driver";
    @DefaultValue(value="")
    public static final String TAG_DB_URL = "db.url";
    @DefaultValue(value="")
    public static final String TAG_DB_USERNAME = "db.username";
    @DefaultValue(value="")
    public static final String TAG_DB_PASSWRD = "db.password";
    public static final String TAG_DB_MAXCONN = "db.conn.max";
    public static final String TAG_DB_MAXIDLE = "db.conn.idle.max";
    public static final String TAG_DB_MINIDLE = "db.conn.idle.min";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionUtils.class);
    private static final Map<String, ConnectionSource> EXISTING_POOLS = new HashMap<String, ConnectionSource>();

    private ConnectionUtils() {
    }

    public static Connection getConnection(String name, Settings settings) throws SQLException {
        Connection connection = ConnectionUtils.getPoolingConnection(name, settings);
        connection.setAutoCommit(false);
        return connection;
    }

    public static Connection getPoolingConnection(String name, Settings settings) throws SQLException {
        ConnectionSource source = EXISTING_POOLS.get(name);
        if (source == null) {
            source = ConnectionUtils.createPoolingConnection(name, settings);
        }
        return source.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConnectionSource createPoolingConnection(String name, Settings settings) {
        Map<String, ConnectionSource> map = EXISTING_POOLS;
        synchronized (map) {
            ConnectionSource source = EXISTING_POOLS.get(name);
            if (source == null) {
                source = !settings.get(TAG_DB_URL, ConnectionUtils.class, false).isEmpty() ? ConnectionUtils.setupBasicDataSource(settings) : ConnectionUtils.setupDataSource(settings);
                EXISTING_POOLS.put(name, source);
            }
            return source;
        }
    }

    private static ConnectionSource setupBasicDataSource(Settings settings) {
        LOGGER.info("Setting up BasicDataSource for database connections.");
        String driver = settings.get(TAG_DB_DRIVER, ConnectionUtils.class);
        if (driver.isEmpty()) {
            throw new IllegalArgumentException("Property 'db.driver' must be non-empty");
        }
        try {
            Class.forName(driver);
            BasicDataSource ds2 = new BasicDataSource();
            ds2.setUrl(settings.get(TAG_DB_URL, ConnectionUtils.class, false));
            ds2.setUsername(settings.get(TAG_DB_USERNAME, ConnectionUtils.class));
            ds2.setPassword(settings.get(TAG_DB_PASSWRD, ConnectionUtils.class, false));
            ds2.setMaxIdle(settings.getInt(TAG_DB_MAXIDLE, ds2.getMaxIdle()));
            ds2.setMaxTotal(settings.getInt(TAG_DB_MAXCONN, ds2.getMaxTotal()));
            ds2.setMinIdle(settings.getInt(TAG_DB_MINIDLE, ds2.getMinIdle()));
            return new ConnectionSourceBasicDataSource(ds2);
        }
        catch (ClassNotFoundException exc) {
            throw new IllegalArgumentException(exc);
        }
    }

    private static ConnectionSource setupDataSource(Settings settings) {
        LOGGER.info("Setting up DataSource for database connections.");
        try {
            String dataSourceName = settings.get(TAG_DATA_SOURCE, ConnectionUtils.class);
            if (dataSourceName.isEmpty()) {
                throw new IllegalArgumentException("Setting db.jndi.datasource must not be empty.");
            }
            InitialContext cxt = new InitialContext();
            DataSource ds2 = (DataSource)cxt.lookup("java:/comp/env/" + dataSourceName);
            if (ds2 == null) {
                throw new IllegalStateException("Data source not found!");
            }
            return new ConnectionSourceDataSource(ds2);
        }
        catch (NamingException exc) {
            throw new IllegalArgumentException("Failed to load context.", exc);
        }
    }

    public static void setupPoolingDriver(String name, String connectURI, String username, String password) throws ClassNotFoundException, SQLException {
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(connectURI, username, password);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, null);
        GenericObjectPool<PoolableConnection> connectionPool = new GenericObjectPool<PoolableConnection>(poolableConnectionFactory);
        poolableConnectionFactory.setPool(connectionPool);
        Class.forName("org.apache.commons.dbcp2.PoolingDriver");
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.registerPool(name, connectionPool);
    }

    public static class ConnectionWrapper
    implements Supplier<Connection>,
    AutoCloseable {
        private final Settings settings;
        private final String connectionName;
        private Connection connection;

        public ConnectionWrapper(Settings settings, String connectionName) {
            this.settings = settings;
            this.connectionName = connectionName;
        }

        @Override
        public Connection get() {
            if (this.connection == null) {
                try {
                    this.connection = ConnectionUtils.getConnection(this.connectionName, this.settings);
                }
                catch (SQLException ex2) {
                    LOGGER.error("Could not inizialize {}", (Object)this.getClass().getName(), (Object)ex2);
                }
            }
            return this.connection;
        }

        public boolean commit() {
            if (this.connection == null) {
                return true;
            }
            try {
                if (!this.connection.isClosed()) {
                    this.connection.commit();
                    return true;
                }
            }
            catch (SQLException ex2) {
                LOGGER.error("Exception rolling back.", ex2);
            }
            return false;
        }

        public boolean rollback() {
            if (this.connection == null) {
                return true;
            }
            try {
                if (!this.connection.isClosed()) {
                    LOGGER.debug("Rolling back changes.");
                    this.connection.rollback();
                    return true;
                }
            }
            catch (SQLException ex2) {
                LOGGER.error("Exception rolling back.", ex2);
            }
            return false;
        }

        @Override
        public void close() throws SQLException {
            if (this.connection == null) {
                return;
            }
            try {
                this.connection.close();
            }
            finally {
                this.clear();
            }
        }

        private void clear() {
            this.connection = null;
        }
    }

    private static class ConnectionSourceBasicDataSource
    implements ConnectionSource {
        private final BasicDataSource dataSource;

        public ConnectionSourceBasicDataSource(BasicDataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.dataSource.getConnection();
        }
    }

    private static class ConnectionSourceDataSource
    implements ConnectionSource {
        private final DataSource ds;

        public ConnectionSourceDataSource(DataSource ds2) {
            this.ds = ds2;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.ds.getConnection();
        }
    }

    private static interface ConnectionSource {
        public Connection getConnection() throws SQLException;
    }
}

