/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables;

import de.fraunhofer.iosb.ilt.frostserver.model.DefaultEntity;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySetImpl;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.PostgresPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.JsonBinding;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.bindings.JsonValue;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.EntityFactories;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPreDelete;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPreInsert;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.factories.HookPreUpdate;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.JsonFieldFactory;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.Relation;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.RelationManyToMany;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.RelationOneToMany;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.CustomField;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.TableCollection;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.DataSize;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.PropertyFieldRegistry;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.QueryState;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.SortingWrapper;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.TableRef;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.Utils;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyCustomSelect;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.util.ParserUtils;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.NoSuchEntityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jooq.Binding;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.TableField;
import org.jooq.impl.DSL;
import org.jooq.impl.TableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StaTableAbstract<T extends StaMainTable<T>>
extends TableImpl<Record>
implements StaMainTable<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaTableAbstract.class.getName());
    private static final String DO_NOT_KNOW_HOW_TO_JOIN = "Do not know how to join ";
    public static final String TYPE_JSONB = "\"pg_catalog\".\"jsonb\"";
    public static final String TYPE_GEOMETRY = "\"public\".\"geometry\"";
    private transient TableCollection tables;
    private transient ModelRegistry modelRegistry;
    private transient Map<String, Relation<T>> relations;
    private List<CustomField> customFields;
    protected transient PropertyFieldRegistry<T> pfReg;
    private final DataType<?> idType;
    private final transient SortedSet<SortingWrapper<Double, HookPreInsert>> hooksPreInsert;
    private final transient SortedSet<SortingWrapper<Double, HookPreUpdate>> hooksPreUpdate;
    private final transient SortedSet<SortingWrapper<Double, HookPreDelete>> hooksPreDelete;

    protected StaTableAbstract(DataType<?> idType, Name alias, StaTableAbstract<T> aliased) {
        super(alias, null, aliased);
        this.idType = idType;
        if (aliased == null) {
            this.pfReg = new PropertyFieldRegistry<StaMainTable>((StaMainTable)this.getThis());
            this.relations = new HashMap<String, Relation<T>>();
            this.hooksPreInsert = new TreeSet<SortingWrapper<Double, HookPreInsert>>();
            this.hooksPreUpdate = new TreeSet<SortingWrapper<Double, HookPreUpdate>>();
            this.hooksPreDelete = new TreeSet<SortingWrapper<Double, HookPreDelete>>();
            this.customFields = new ArrayList<CustomField>();
        } else {
            this.init(aliased.getModelRegistry(), aliased.getTables());
            this.pfReg = new PropertyFieldRegistry<StaMainTable>((StaMainTable)this.getThis(), aliased.getPropertyFieldRegistry());
            this.relations = aliased.relations;
            this.hooksPreInsert = aliased.hooksPreInsert;
            this.hooksPreUpdate = aliased.hooksPreUpdate;
            this.hooksPreDelete = aliased.hooksPreDelete;
            this.customFields = aliased.customFields;
        }
    }

    public DataType<?> getIdType() {
        return this.idType;
    }

    @Override
    public final int registerField(Name name, DataType type, Binding binding) {
        this.customFields.add(new CustomField(name, type, binding));
        TableField newField = this.createField(name, type, "", binding);
        return this.fieldsRow().indexOf(newField);
    }

    protected T initCustomFields() {
        for (CustomField customField : this.customFields) {
            this.createField(customField.name, customField.type, "", customField.binding);
        }
        return (T)((StaMainTable)this.getThis());
    }

    @Override
    public void registerRelation(Relation<T> relation) {
        this.relations.put(relation.getName(), relation);
    }

    @Override
    public void registerHookPreInsert(double priority, HookPreInsert hook) {
        this.hooksPreInsert.add(new SortingWrapper<Double, HookPreInsert>(priority, hook));
    }

    @Override
    public void registerHookPreUpdate(double priority, HookPreUpdate hook) {
        this.hooksPreUpdate.add(new SortingWrapper<Double, HookPreUpdate>(priority, hook));
    }

    @Override
    public void registerHookPreDelete(double priority, HookPreDelete hook) {
        this.hooksPreDelete.add(new SortingWrapper<Double, HookPreDelete>(priority, hook));
    }

    @Override
    public Relation<T> findRelation(String name) {
        Relation<T> relation = this.relations.get(name);
        if (relation == null) {
            throw new IllegalStateException(DO_NOT_KNOW_HOW_TO_JOIN + name + " on " + this.getName() + " " + this.getClass().getName());
        }
        return relation;
    }

    @Override
    public TableRef createJoin(String name, QueryState<?> queryState, TableRef sourceRef) {
        return this.findRelation(name).join((StaMainTable)this.getThis(), queryState, sourceRef);
    }

    @Override
    public PropertyFieldRegistry<T> getPropertyFieldRegistry() {
        if (this.pfReg == null) {
            this.pfReg = new PropertyFieldRegistry<StaMainTable>((StaMainTable)this.getThis());
        }
        return this.pfReg;
    }

    @Override
    public Entity entityFromQuery(Record tuple, QueryState<T> state, DataSize dataSize) {
        DefaultEntity newEntity = new DefaultEntity(this.getEntityType());
        for (PropertyFieldRegistry.PropertyFields<T> sp : state.getSelectedProperties()) {
            sp.converter.convert(state.getMainTable(), tuple, newEntity, dataSize);
        }
        return newEntity;
    }

    @Override
    public boolean insertIntoDatabase(PostgresPersistenceManager pm2, Entity entity) throws NoSuchEntityException, IncompleteEntityException {
        StaMainTable thisTable = (StaMainTable)this.getThis();
        EntityFactories entityFactories = pm2.getEntityFactories();
        EntityType entityType = entity.getEntityType();
        HashMap<Field, Object> insertFields = new HashMap<Field, Object>();
        for (SortingWrapper sortingWrapper : this.hooksPreInsert) {
            if (((HookPreInsert)sortingWrapper.getObject()).insertIntoDatabase(pm2, entity, insertFields)) continue;
            return false;
        }
        for (NavigationPropertyMain navigationPropertyMain : entityType.getNavigationEntities()) {
            if (!entity.isSetProperty(navigationPropertyMain)) continue;
            Entity ne2 = (Entity)entity.getProperty(navigationPropertyMain);
            entityFactories.entityExistsOrCreate(pm2, ne2);
            PropertyFieldRegistry.PropertyFields<T> registry = this.pfReg.getSelectFieldsForProperty(navigationPropertyMain);
            registry.converter.convert(thisTable, entity, insertFields);
        }
        entityFactories.insertUserDefinedId(pm2, insertFields, this.getId(), entity);
        Set<EntityPropertyMain> entityProperties = entityType.getEntityProperties();
        EntityPropertyMain<Id> entityPropertyMain = entityType.getPrimaryKey();
        for (EntityPropertyMain ep2 : entityProperties) {
            if (ep2.equals(entityPropertyMain) || !entity.isSetProperty(ep2)) continue;
            this.pfReg.getSelectFieldsForProperty((Property)ep2).converter.convert(thisTable, entity, insertFields);
        }
        DSLContext dslContext = pm2.getDslContext();
        Object entityId = dslContext.insertInto(thisTable).set(insertFields).returningResult(thisTable.getId()).fetchOne(0);
        LOGGER.debug("Inserted Entity. Created id = {}.", entityId);
        entity.setId(ParserUtils.idFromObject(entityId));
        for (NavigationPropertyMain<EntitySet> np3 : entityType.getNavigationSets()) {
            if (!entity.isSetProperty(np3)) continue;
            this.updateNavigationPropertySet(entity, entity.getProperty(np3), pm2, true);
        }
        return true;
    }

    protected void updateNavigationPropertySet(Entity entity, EntitySet linkedSet, PostgresPersistenceManager pm2, boolean forInsert) throws IncompleteEntityException, NoSuchEntityException {
        Object entityId = entity.getId().getValue();
        EntityType entityType = this.getEntityType();
        EntityType linkedType = linkedSet.getEntityType();
        NavigationPropertyMain backLink = linkedType.getNavigationProperty(entityType);
        Relation<T> relation = this.findRelation(linkedSet.getNavigationProperty().getName());
        RelationManyToMany relationManyToMany = null;
        if (backLink == null) {
            LOGGER.error("Target type ({}) does not actually link to this ({}).", (Object)linkedSet.getEntityType(), (Object)entityType);
            throw new IllegalStateException("Target type (" + linkedSet.getEntityType() + ") does not actually link to this (" + entityType + ").");
        }
        if (backLink.isEntitySet()) {
            if (relation instanceof RelationManyToMany) {
                relationManyToMany = (RelationManyToMany)relation;
            } else {
                LOGGER.error("Target type ({}) and this ({}) not linked by RelationManyToMany.", (Object)linkedSet.getEntityType(), (Object)entityType);
                throw new IllegalStateException("Many-to-many relation not linked by RelationManyToMany");
            }
        }
        EntityFactories entityFactories = pm2.getEntityFactories();
        for (Entity child : linkedSet) {
            if (relationManyToMany == null) {
                if (entityFactories.entityExists(pm2, child)) {
                    ((RelationOneToMany)relation).link(pm2, entityId, child.getId().getValue());
                    continue;
                }
                if (forInsert) {
                    child.setProperty(backLink, entity);
                    child.complete();
                    pm2.insert(child);
                    continue;
                }
                throw new NoSuchEntityException("Linked Entity with no id.");
            }
            if (forInsert) {
                entityFactories.entityExistsOrCreate(pm2, child);
            } else if (!entityFactories.entityExists(pm2, child)) {
                throw new NoSuchEntityException("Linked Entity with no id.");
            }
            relationManyToMany.link(pm2, entityId, child.getId().getValue());
        }
    }

    @Override
    public EntityChangedMessage updateInDatabase(PostgresPersistenceManager pm2, Entity entity, Object entityId) throws NoSuchEntityException, IncompleteEntityException {
        StaMainTable thisTable = (StaMainTable)this.getThis();
        EntityFactories entityFactories = pm2.getEntityFactories();
        EntityType entityType = entity.getEntityType();
        HashMap<Field, Object> updateFields = new HashMap<Field, Object>();
        EntityChangedMessage message = new EntityChangedMessage();
        for (SortingWrapper sortingWrapper : this.hooksPreUpdate) {
            ((HookPreUpdate)sortingWrapper.getObject()).updateInDatabase(pm2, entity, entityId);
        }
        for (NavigationPropertyMain navigationPropertyMain : entityType.getNavigationEntities()) {
            if (!entity.isSetProperty(navigationPropertyMain)) continue;
            Entity ne2 = (Entity)entity.getProperty(navigationPropertyMain);
            if (!entityFactories.entityExists(pm2, ne2)) {
                throw new NoSuchEntityException("Linked " + ne2.getEntityType() + " not found.");
            }
            PropertyFieldRegistry.PropertyFields<T> registry = this.pfReg.getSelectFieldsForProperty(navigationPropertyMain);
            registry.converter.convert(thisTable, entity, updateFields, message);
        }
        Set<EntityPropertyMain> entityProperties = entityType.getEntityProperties();
        EntityPropertyMain<Id> entityPropertyMain = entityType.getPrimaryKey();
        for (EntityPropertyMain ep2 : entityProperties) {
            if (ep2.equals(entityPropertyMain) || !entity.isSetProperty(ep2)) continue;
            this.pfReg.getSelectFieldsForProperty((Property)ep2).converter.convert(thisTable, entity, updateFields, message);
        }
        DSLContext dslContext = pm2.getDslContext();
        long count = 0L;
        if (!updateFields.isEmpty()) {
            count = dslContext.update(thisTable).set(updateFields).where(thisTable.getId().equal(entityId)).execute();
        }
        if (count > 1L) {
            LOGGER.error("Updating {} {} caused {} rows to change!", this.getEntityType(), entityId, count);
            throw new IllegalStateException("Update changed multiple rows.");
        }
        for (NavigationPropertyMain<EntitySet> np3 : entityType.getNavigationSets()) {
            if (!entity.isSetProperty(np3)) continue;
            this.updateNavigationPropertySet(entity, entity.getProperty(np3), pm2, false);
        }
        return message;
    }

    @Override
    public void delete(PostgresPersistenceManager pm2, Object entityId) throws NoSuchEntityException {
        for (SortingWrapper sortingWrapper : this.hooksPreDelete) {
            ((HookPreDelete)sortingWrapper.getObject()).delete(pm2, entityId);
        }
        StaMainTable thisTable = (StaMainTable)this.getThis();
        long l2 = pm2.getDslContext().delete(thisTable).where(thisTable.getId().eq(entityId)).execute();
        if (l2 == 0L) {
            throw new NoSuchEntityException("Entity of type " + this.getEntityType() + " with id " + entityId + " not found.");
        }
        LOGGER.debug("Deleted {} Entities of type {}", (Object)l2, (Object)this.getEntityType());
    }

    @Override
    public EntitySet newSet() {
        return new EntitySetImpl(this.getEntityType());
    }

    @Override
    public abstract T as(Name var1);

    public final T as(String alias) {
        return (T)this.as(DSL.name(alias));
    }

    public ModelRegistry getModelRegistry() {
        return this.modelRegistry;
    }

    public final TableCollection getTables() {
        return this.tables;
    }

    public final void init(ModelRegistry modelRegistry, TableCollection tables) {
        this.modelRegistry = modelRegistry;
        this.tables = tables;
    }

    @Override
    public PropertyFieldRegistry.PropertyFields<T> handleEntityPropertyCustomSelect(EntityPropertyCustomSelect epCustomSelect) {
        String epName = epCustomSelect.getMainEntityPropertyName();
        EntityPropertyMain mainEntityProperty = this.getEntityType().getEntityProperty(epName);
        if (mainEntityProperty.hasCustomProperties) {
            PropertyFieldRegistry.PropertyFields<T> mainPropertyFields = this.pfReg.getSelectFieldsForProperty(mainEntityProperty);
            if (mainPropertyFields.jsonType) {
                PropertyFieldRegistry.ExpressionFactory<StaMainTable> factory = mainPropertyFields.fields.get("j");
                if (factory == null) {
                    factory = mainPropertyFields.fields.values().iterator().next();
                }
                Field mainField = factory.get((StaMainTable)this.getThis());
                JsonFieldFactory.JsonFieldWrapper jsonFactory = StaTableAbstract.jsonFieldFromPath(mainField, epCustomSelect);
                return this.propertyFieldForJsonField(jsonFactory, epCustomSelect);
            }
            PropertyFieldRegistry.ExpressionFactory<StaMainTable> factory = mainPropertyFields.fields.get(epCustomSelect.getSubPath().get(0));
            if (factory == null) {
                throw new IllegalArgumentException("No path: " + epCustomSelect);
            }
            Field field = factory.get((StaMainTable)this.getThis());
            return this.propertyFieldForCustom(field, epCustomSelect);
        }
        return null;
    }

    public static JsonFieldFactory.JsonFieldWrapper jsonFieldFromPath(Field mainField, EntityPropertyCustomSelect epCustomSelect) {
        JsonFieldFactory.JsonFieldWrapper jsonFactory = new JsonFieldFactory.JsonFieldWrapper(mainField);
        for (String pathItem : epCustomSelect.getSubPath()) {
            jsonFactory.addToPath(pathItem);
        }
        return jsonFactory;
    }

    protected PropertyFieldRegistry.PropertyFields<T> propertyFieldForJsonField(JsonFieldFactory.JsonFieldWrapper jsonFactory, EntityPropertyCustomSelect epCustomSelect) {
        Field<Object> deepField = jsonFactory.materialise().getJsonExpression();
        PropertyFieldRegistry.PropertyFields<StaMainTable> pfs = new PropertyFieldRegistry.PropertyFields<StaMainTable>(epCustomSelect, new PropertyFieldRegistry.ConverterRecordDeflt<StaMainTable>((tbl, tuple, entity, dataSize) -> {
            JsonValue jsonValue = JsonBinding.getConverterInstance().from(tuple.get(deepField));
            dataSize.increase(jsonValue.getStringLength());
            Object value = jsonValue.getValue(Utils.TYPE_OBJECT);
            epCustomSelect.setOn(entity, value);
        }, null, null));
        pfs.addField("1", t2 -> deepField);
        return pfs;
    }

    protected PropertyFieldRegistry.PropertyFields<T> propertyFieldForCustom(Field field, EntityPropertyCustomSelect epCustomSelect) {
        PropertyFieldRegistry.PropertyFields<StaMainTable> pfs = new PropertyFieldRegistry.PropertyFields<StaMainTable>(epCustomSelect, new PropertyFieldRegistry.ConverterRecordDeflt<StaMainTable>((tbl, tuple, entity, dataSize) -> epCustomSelect.setOn(entity, tuple.get(field)), null, null));
        pfs.addField("1", t2 -> field);
        return pfs;
    }
}

