/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.PostgresPersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.QueryBuilder;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.FieldAccessor;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.relations.Relation;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaMainTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.tables.StaTable;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.QueryState;
import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.utils.TableRef;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import org.jooq.Field;
import org.jooq.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationManyToMany<S extends StaMainTable<S>, L extends StaTable<L>, T extends StaMainTable<T>>
implements Relation<S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationManyToMany.class.getName());
    private final EntityType targetType;
    private final String name;
    private FieldAccessor<S> sourceFieldAcc;
    private final L linkTable;
    private FieldAccessor<L> sourceLinkFieldAcc;
    private FieldAccessor<L> targetLinkFieldAcc;
    private final T target;
    private FieldAccessor<T> targetFieldAcc;

    public RelationManyToMany(NavigationPropertyMain navProp, S source, L linkTable, T target) {
        if (source == null) {
            LOGGER.error("NULL source");
        }
        this.linkTable = linkTable;
        this.target = target;
        this.targetType = navProp.getEntityType();
        this.name = navProp.getName();
    }

    public FieldAccessor<S> getSourceFieldAcc() {
        return this.sourceFieldAcc;
    }

    public RelationManyToMany<S, L, T> setSourceFieldAcc(FieldAccessor<S> sourceFieldAcc) {
        this.sourceFieldAcc = sourceFieldAcc;
        return this;
    }

    public L getLinkTable() {
        return this.linkTable;
    }

    public FieldAccessor<L> getSourceLinkFieldAcc() {
        return this.sourceLinkFieldAcc;
    }

    public RelationManyToMany<S, L, T> setSourceLinkFieldAcc(FieldAccessor<L> sourceLinkFieldAcc) {
        this.sourceLinkFieldAcc = sourceLinkFieldAcc;
        return this;
    }

    public FieldAccessor<L> getTargetLinkFieldAcc() {
        return this.targetLinkFieldAcc;
    }

    public RelationManyToMany<S, L, T> setTargetLinkFieldAcc(FieldAccessor<L> targetLinkFieldAcc) {
        this.targetLinkFieldAcc = targetLinkFieldAcc;
        return this;
    }

    public FieldAccessor<T> getTargetFieldAcc() {
        return this.targetFieldAcc;
    }

    public RelationManyToMany<S, L, T> setTargetFieldAcc(FieldAccessor<T> targetFieldAcc) {
        this.targetFieldAcc = targetFieldAcc;
        return this;
    }

    public T getTarget() {
        return this.target;
    }

    public EntityType getTargetType() {
        return this.targetType;
    }

    @Override
    public TableRef join(S source, QueryState<?> queryState, TableRef sourceRef) {
        Table linkTableAliased = this.linkTable.as(queryState.getNextAlias());
        StaTable targetAliased = this.target.as(queryState.getNextAlias());
        Field sourceField = this.sourceFieldAcc.getField(source);
        Field sourceLinkField = this.sourceLinkFieldAcc.getField(linkTableAliased);
        Field targetLinkField = this.targetLinkFieldAcc.getField(linkTableAliased);
        Field targetField = this.targetFieldAcc.getField(targetAliased);
        queryState.setSqlFrom(queryState.getSqlFrom().innerJoin(linkTableAliased).on(sourceLinkField.eq(sourceField)));
        queryState.setSqlFrom(queryState.getSqlFrom().innerJoin(targetAliased).on(targetField.eq(targetLinkField)));
        queryState.setDistinctRequired(true);
        return QueryBuilder.createJoinedRef(sourceRef, this.targetType, targetAliased);
    }

    @Override
    public void link(PostgresPersistenceManager pm2, Object sourceId, Object targetId) {
        pm2.getDslContext().insertInto(this.linkTable).set(this.sourceLinkFieldAcc.getField(this.linkTable), sourceId).set(this.targetLinkFieldAcc.getField(this.linkTable), targetId).execute();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

