/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper;

import de.fraunhofer.iosb.ilt.frostserver.persistence.pgjooq.fieldwrapper.FieldWrapper;
import java.util.Collection;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.impl.DSL;

public class FieldListWrapper
implements FieldWrapper {
    private final Map<String, Field> expressions;
    private final Map<String, Field> expressionsForOrder;
    private boolean conditionChecked = false;
    private Condition condition;

    public FieldListWrapper(Map<String, Field> expressions) {
        this.expressions = expressions;
        this.expressionsForOrder = expressions;
    }

    public FieldListWrapper(Map<String, Field> expressions, Map<String, Field> expressionsForOrder) {
        this.expressions = expressions;
        this.expressionsForOrder = expressionsForOrder;
    }

    @Override
    public boolean isCondition() {
        if (this.condition != null) {
            return true;
        }
        if (this.conditionChecked) {
            return false;
        }
        this.conditionChecked = true;
        for (Field expression : this.getExpressions().values()) {
            if (!Boolean.class.isAssignableFrom(expression.getType())) continue;
            this.condition = DSL.condition(expression);
            return true;
        }
        return false;
    }

    @Override
    public Condition getCondition() {
        if (!this.conditionChecked && this.condition == null) {
            this.isCondition();
        }
        return this.condition;
    }

    @Override
    public Field getDefaultField() {
        return this.expressions.values().iterator().next();
    }

    @Override
    public <T> Field<T> getFieldAsType(Class<T> expectedClazz, boolean canCast) {
        Class fieldType;
        Collection<Field> values = this.expressions.values();
        for (Field subResult : values) {
            fieldType = subResult.getType();
            if (!expectedClazz.isAssignableFrom(fieldType)) continue;
            return subResult;
        }
        for (Field subResult : values) {
            fieldType = subResult.getType();
            if (expectedClazz != String.class || !Number.class.isAssignableFrom(fieldType)) continue;
            return subResult.cast(String.class);
        }
        return null;
    }

    public final Map<String, Field> getExpressions() {
        return this.expressions;
    }

    public final Map<String, Field> getExpressionsForOrder() {
        return this.expressionsForOrder;
    }

    public Field getExpression(String name) {
        return this.expressions.get(name);
    }

    public String toString() {
        return this.getClass().getName() + " Expressions: " + this.expressions.toString();
    }
}

