/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.persistence;

import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.PersistenceSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.LiquibaseUser;
import de.fraunhofer.iosb.ilt.frostserver.util.LiquibaseUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceManagerFactory {
    private static final String ERROR_MSG = "Could not generate PersistenceManager instance: ";
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistenceManagerFactory.class);
    private static final Map<CoreSettings, PersistenceManagerFactory> instances = new HashMap<CoreSettings, PersistenceManagerFactory>();
    private boolean maybeUpdateDatabase = true;
    private final Class persistenceManagerClass;
    private final CoreSettings settings;

    public static synchronized PersistenceManagerFactory init(CoreSettings coreSettings) {
        PersistenceManagerFactory instance = instances.computeIfAbsent(coreSettings, t2 -> {
            PersistenceManagerFactory newInstance = new PersistenceManagerFactory(coreSettings);
            PersistenceSettings persistenceSettings = coreSettings.getPersistenceSettings();
            newInstance.maybeUpdateDatabase = persistenceSettings.isAutoUpdateDatabase();
            return newInstance;
        });
        instance.maybeUpdateDatabase();
        return instance;
    }

    public static PersistenceManagerFactory getInstance(CoreSettings coreSettings) {
        PersistenceManagerFactory instance = instances.get(coreSettings);
        if (instance == null) {
            instance = PersistenceManagerFactory.init(coreSettings);
        }
        return instance;
    }

    private PersistenceManagerFactory(CoreSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("settings must be non-null");
        }
        this.settings = settings;
        try {
            String pmiClsName = settings.getPersistenceSettings().getPersistenceManagerImplementationClass();
            this.persistenceManagerClass = Class.forName(pmiClsName);
        }
        catch (ClassNotFoundException ex2) {
            throw new IllegalArgumentException("Could not generate PersistenceManager instance: Class '" + settings.getPersistenceSettings().getPersistenceManagerImplementationClass() + "' could not be found", ex2);
        }
    }

    public PersistenceManager create() {
        PersistenceManager persistenceManager = null;
        try {
            persistenceManager = (PersistenceManager)this.persistenceManagerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            persistenceManager.init(this.settings);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex2) {
            LOGGER.error("{} Class '{}' could not be instantiated", ERROR_MSG, this.settings.getPersistenceSettings().getPersistenceManagerImplementationClass(), ex2);
        }
        return persistenceManager;
    }

    public void maybeUpdateDatabase() {
        if (this.maybeUpdateDatabase) {
            Set<LiquibaseUser> liquibaseUsers;
            PersistenceManager pm2 = this.create();
            if (pm2 instanceof LiquibaseUser) {
                LiquibaseUtils.maybeUpdateDatabase(LOGGER, (LiquibaseUser)((Object)pm2));
            }
            if ((liquibaseUsers = this.settings.getLiquibaseUsers()).isEmpty()) {
                return;
            }
            for (LiquibaseUser lbu : liquibaseUsers) {
                if (!LiquibaseUtils.maybeUpdateDatabase(LOGGER, lbu)) continue;
                return;
            }
            this.maybeUpdateDatabase = false;
        }
    }
}

