/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.path;

import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.path.SyntheticPropertyRegistry;
import java.util.Map;
import java.util.TreeMap;

public class Version {
    private static final SyntheticPropertyRegistry spr = new SyntheticPropertyRegistry();
    public static final Version V_1_0 = new Version("v1.0", spr);
    public static final Version V_1_1 = new Version("v1.1", spr);
    public final String urlPart;
    public final SyntheticPropertyRegistry syntheticPropertyRegistry;
    public final Map<CannedResponseType, CannedResponse> responses = new TreeMap<CannedResponseType, CannedResponse>();

    public Version(String urlPart) {
        this.urlPart = urlPart;
        this.syntheticPropertyRegistry = new SyntheticPropertyRegistry();
    }

    public Version(String urlPart, SyntheticPropertyRegistry syntheticPropertyRegistry) {
        this.urlPart = urlPart;
        this.syntheticPropertyRegistry = syntheticPropertyRegistry;
    }

    public String toString() {
        return this.urlPart;
    }

    public CannedResponse getCannedResponse(CannedResponseType type) {
        return this.responses.getOrDefault((Object)type, type.dflt);
    }

    static {
        spr.registerProperty(ModelRegistry.EP_SELFLINK);
    }

    public static class CannedResponse {
        public final int code;
        public final String message;

        public CannedResponse(int code, String message) {
            this.code = code;
            this.message = message;
        }
    }

    public static enum CannedResponseType {
        NOTHING_FOUND(new CannedResponse(404, "Not Found"));

        public final CannedResponse dflt;

        private CannedResponseType(CannedResponse dflt) {
            this.dflt = dflt;
        }
    }
}

