/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.path;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntityType;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePathVisitor;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import java.util.Objects;

public class PathElementEntity
implements PathElementEntityType {
    private final NavigationPropertyMain.NavigationPropertyEntity np;
    private final EntityType entityType;
    private PathElement parent;
    private Id id;

    public PathElementEntity(NavigationPropertyMain.NavigationPropertyEntity np2, PathElement parent) {
        this.np = np2;
        this.entityType = null;
        this.parent = parent;
    }

    public PathElementEntity(EntityType entityType, PathElement parent) {
        this.np = null;
        this.entityType = entityType;
        this.parent = parent;
    }

    public PathElementEntity(Id id2, EntityType entityType, PathElement parent) {
        this.np = null;
        this.entityType = entityType;
        this.parent = parent;
        this.id = id2;
    }

    public Id getId() {
        return this.id;
    }

    @Override
    public String getName() {
        if (this.np != null) {
            return this.np.getName();
        }
        return this.entityType.entityName;
    }

    @Override
    public NavigationPropertyMain.NavigationPropertyEntity getNavigationProperty() {
        return this.np;
    }

    @Override
    public EntityType getEntityType() {
        if (this.np != null) {
            return this.np.getEntityType();
        }
        return this.entityType;
    }

    @Override
    public PathElement getParent() {
        return this.parent;
    }

    public PathElementEntity setId(Id id2) {
        this.id = id2;
        return this;
    }

    @Override
    public void setParent(PathElement parent) {
        this.parent = parent;
    }

    @Override
    public void visit(ResourcePathVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.entityType, this.np, this.parent);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathElementEntity other = (PathElementEntity)obj;
        return Objects.equals(this.id, other.id) && this.np == other.np && this.entityType == other.entityType && Objects.equals(this.parent, other.parent);
    }
}

