/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.parser.query;

import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTBool;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTBooleanFunction;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTComparison;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTFilter;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTFunction;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTGeoStringLit;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTLogicalAnd;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTLogicalOr;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTMulDiv;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTNot;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTOperator;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTPathElement;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTPlainPath;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTPlusMin;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.ASTValueNode;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.AbstractParserVisitor;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.Node;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.SimpleNode;
import de.fraunhofer.iosb.ilt.frostserver.query.PropertyPlaceholder;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Expression;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Path;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.BooleanConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.Constant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.DoubleConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.GeoJsonConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.IntegerConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.constant.StringConstant;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.Function;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.FunctionTypeBinding;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.arithmetic.Add;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.arithmetic.Divide;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.arithmetic.Modulo;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.arithmetic.Multiply;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.arithmetic.Subtract;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.comparison.Equal;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.comparison.GreaterEqual;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.comparison.GreaterThan;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.comparison.LessEqual;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.comparison.LessThan;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.comparison.NotEqual;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.date.Date;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.date.Day;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.date.FractionalSeconds;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.date.Hour;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.date.MaxDateTime;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.date.MinDateTime;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.date.Minute;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.date.Month;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.date.Now;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.date.Second;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.date.Time;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.date.TotalOffsetMinutes;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.date.Year;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.logical.And;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.logical.Not;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.logical.Or;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.math.Ceiling;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.math.Floor;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.math.Round;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.spatialrelation.GeoDistance;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.spatialrelation.GeoIntersects;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.spatialrelation.GeoLength;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.spatialrelation.STContains;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.spatialrelation.STCrosses;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.spatialrelation.STDisjoint;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.spatialrelation.STEquals;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.spatialrelation.STIntersects;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.spatialrelation.STOverlaps;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.spatialrelation.STRelate;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.spatialrelation.STTouches;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.spatialrelation.STWithin;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.string.Concat;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.string.EndsWith;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.string.IndexOf;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.string.Length;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.string.StartsWith;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.string.Substring;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.string.SubstringOf;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.string.ToLower;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.string.ToUpper;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.string.Trim;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.temporal.After;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.temporal.Before;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.temporal.During;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.temporal.Finishes;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.temporal.Meets;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.temporal.Overlaps;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.function.temporal.Starts;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ExpressionParser
extends AbstractParserVisitor {
    private static final String GEOGRAPHY_REGEX = "^geography'([^']+)'$";
    private static final Pattern GEORAPHY_PATTERN = Pattern.compile("^geography'([^']+)'$");

    public Expression parseExpression(Node node) {
        return this.visit(node, null);
    }

    @Override
    public Path visit(ASTPlainPath node, Object data) {
        PropertyPlaceholder property = null;
        for (int i2 = 0; i2 < node.jjtGetNumChildren(); ++i2) {
            Node child = node.jjtGetChild(i2);
            if (!(child instanceof ASTPathElement)) {
                throw new IllegalArgumentException("alle childs of ASTPlainPath must be of type ASTPathElement");
            }
            property = this.visit((ASTPathElement)child, property);
        }
        return new Path(property);
    }

    @Override
    public PropertyPlaceholder visit(ASTPathElement node, Object data) {
        if (node.getIdentifier() != null && !node.getIdentifier().isEmpty()) {
            throw new IllegalArgumentException("no identified paths are allowed inside expressions");
        }
        if (data instanceof PropertyPlaceholder) {
            return ((PropertyPlaceholder)data).addToSubPath(node.getName());
        }
        return new PropertyPlaceholder(node.getName());
    }

    @Override
    public Expression visit(ASTFilter node, Object data) {
        if (node.jjtGetNumChildren() != 1) {
            throw new IllegalArgumentException("filter node must have exactly one child!");
        }
        return this.visit(node.jjtGetChild(0), data);
    }

    @Override
    public Or visit(ASTLogicalOr node, Object data) {
        return (Or)this.visitLogicalFunction(Operator.OP_OR, node, data);
    }

    @Override
    public And visit(ASTLogicalAnd node, Object data) {
        return (And)this.visitLogicalFunction(Operator.OP_AND, node, data);
    }

    private Function visitLogicalFunction(Operator operator, Node node, Object data) {
        if (node.jjtGetNumChildren() < 2) {
            throw new IllegalArgumentException("'" + operator + "' must have at least two parameters");
        }
        Function function = operator.instantiate();
        Expression result = this.visitChildWithType(function, node.jjtGetChild(node.jjtGetNumChildren() - 1), data, 1);
        for (int i2 = node.jjtGetNumChildren() - 2; i2 >= 0; --i2) {
            function = operator.instantiate();
            Expression lhs = this.visitChildWithType(function, node.jjtGetChild(i2), data, 0);
            function.setParameters(lhs, result);
            result = function;
        }
        return (Function)result;
    }

    @Override
    public Function visit(ASTNot node, Object data) {
        if (node.jjtGetNumChildren() != 1) {
            throw new IllegalArgumentException("'not' must have exactly one parameter");
        }
        return this.visit((ASTFunction)node, data);
    }

    @Override
    public Function visit(ASTBooleanFunction node, Object data) {
        return this.visit((ASTFunction)node, data);
    }

    @Override
    public Function visit(ASTComparison node, Object data) {
        if (node.jjtGetNumChildren() != 2) {
            throw new IllegalArgumentException("comparison must have exactly 2 children");
        }
        return this.visit((ASTFunction)node, data);
    }

    private Expression visit(Node node, Object data) {
        return (Expression)node.jjtAccept(this, data);
    }

    private Function visitArithmeticFunction(SimpleNode node, Object data) {
        int childCount = node.jjtGetNumChildren();
        if (childCount < 3 || childCount % 2 == 0) {
            throw new IllegalArgumentException("add/sub with wrong number of arguments");
        }
        Expression result = null;
        for (int idx = 0; idx < childCount; ++idx) {
            Expression lhs;
            int operatorIndex;
            int n2 = operatorIndex = result == null ? idx + 1 : idx;
            if (!(node.jjtGetChild(operatorIndex) instanceof ASTOperator)) {
                throw new IllegalArgumentException("operator expected but '" + node.jjtGetChild(idx).getClass().getName() + "' found");
            }
            String operatorKey = ((ASTOperator)node.jjtGetChild(operatorIndex)).getName().trim().toLowerCase();
            Function function = this.getFunction(operatorKey);
            if (result == null) {
                lhs = this.visitChildWithType(function, node.jjtGetChild(idx), data, 1);
                ++idx;
            } else {
                lhs = result;
            }
            Expression rhs = this.visitChildWithType(function, node.jjtGetChild(++idx), data, 0);
            function.setParameters(lhs, rhs);
            result = function;
        }
        return result;
    }

    @Override
    public Function visit(ASTPlusMin node, Object data) {
        return this.visitArithmeticFunction(node, data);
    }

    @Override
    public Function visit(ASTMulDiv node, Object data) {
        return this.visitArithmeticFunction(node, data);
    }

    private Function getFunction(String operator) {
        return Operator.fromKey(operator).instantiate();
    }

    @Override
    public Function visit(ASTFunction node, Object data) {
        String operator = node.getName().trim().toLowerCase();
        Function function = this.getFunction(operator);
        function.setParameters(this.visitChildsWithType(function, node, data));
        return function;
    }

    private Expression[] visitChildsWithType(Function function, Node node, Object data) {
        List<FunctionTypeBinding> allowedBindings = function.getAllowedTypeBindings();
        if (data != null) {
            List allowedReturnTypes = (List)data;
            allowedBindings = allowedBindings.stream().filter(x2 -> allowedReturnTypes.contains(x2.getReturnType())).collect(Collectors.toList());
        }
        Expression[] parameters = new Expression[node.jjtGetNumChildren()];
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            parameters[i2] = this.visit(node.jjtGetChild(i2), allowedBindings.stream().map(x2 -> x2.getParameters().get(0)).collect(Collectors.toList()));
        }
        return parameters;
    }

    private Expression visitChildWithType(Function function, Node child, Object data, int parameterIndex) {
        List<FunctionTypeBinding> allowedBindings = function.getAllowedTypeBindings();
        if (data != null) {
            List allowedReturnTypes = (List)data;
            allowedBindings = allowedBindings.stream().filter(x2 -> allowedReturnTypes.contains(x2.getReturnType())).collect(Collectors.toList());
        }
        return this.visit(child, allowedBindings.stream().map(x2 -> x2.getParameters().get(parameterIndex)).collect(Collectors.toList()));
    }

    @Override
    public Constant visit(ASTValueNode node, Object data) {
        Object value = node.jjtGetValue();
        if (value instanceof Boolean) {
            return new BooleanConstant((Boolean)value);
        }
        if (value instanceof Double) {
            return new DoubleConstant((Double)value);
        }
        if (value instanceof Integer) {
            return new IntegerConstant((Integer)value);
        }
        if (value instanceof Long) {
            return new IntegerConstant(((Number)value).longValue());
        }
        if (value instanceof Constant) {
            return (Constant)value;
        }
        return new StringConstant(node.jjtGetValue().toString());
    }

    @Override
    public GeoJsonConstant visit(ASTGeoStringLit node, Object data) {
        String raw = node.jjtGetValue().toString().trim();
        Matcher matcher = GEORAPHY_PATTERN.matcher(raw);
        if (matcher.matches()) {
            return GeoJsonConstant.fromString(matcher.group(1).trim());
        }
        throw new IllegalArgumentException("invalid geography string '" + StringHelper.cleanForLogging(raw) + "'");
    }

    @Override
    public BooleanConstant visit(ASTBool node, Object data) {
        return new BooleanConstant(node.getValue());
    }

    public static enum Operator {
        OP_NOT("not", Not.class),
        OP_AND("and", And.class),
        OP_OR("or", Or.class),
        OP_ADD("+", Add.class),
        OP_SUB("-", Subtract.class),
        OP_MUL("mul", Multiply.class),
        OP_DIV("div", Divide.class),
        OP_MOD("mod", Modulo.class),
        OP_EQUAL("eq", Equal.class),
        OP_NOT_EQUAL("ne", NotEqual.class),
        OP_GREATER_THAN("gt", GreaterThan.class),
        OP_GREATER_EQUAL("ge", GreaterEqual.class),
        OP_LESS_THAN("lt", LessThan.class),
        OP_LESS_EQUAL("le", LessEqual.class),
        OP_SUBSTRING_OF("substringof", SubstringOf.class),
        OP_ENDS_WITH("endswith", EndsWith.class),
        OP_STARTS_WITH("startswith", StartsWith.class),
        OP_LENGTH("length", Length.class),
        OP_INDEX_OF("indexof", IndexOf.class),
        OP_SUBSTRING("substring", Substring.class),
        OP_TO_LOWER("tolower", ToLower.class),
        OP_TO_UPPER("toupper", ToUpper.class),
        OP_TRIM("trim", Trim.class),
        OP_CONCAT("concat", Concat.class),
        OP_YEAR("year", Year.class),
        OP_MONTH("month", Month.class),
        OP_DAY("day", Day.class),
        OP_HOUR("hour", Hour.class),
        OP_MINUTE("minute", Minute.class),
        OP_SECOND("second", Second.class),
        OP_FRACTIONAL_SECONDS("fractionalseconds", FractionalSeconds.class),
        OP_DATE("date", Date.class),
        OP_TIME("time", Time.class),
        OP_TOTAL_OFFSET_MINUTES("totaloffsetminutes", TotalOffsetMinutes.class),
        OP_NOW("now", Now.class),
        OP_MIN_DATETIME("mindatetime", MinDateTime.class),
        OP_MAX_DATETIME("maxdatetime", MaxDateTime.class),
        OP_BEFORE("before", Before.class),
        OP_AFTER("after", After.class),
        OP_MEETS("meets", Meets.class),
        OP_DURING("during", During.class),
        OP_OVERLAPS("overlaps", Overlaps.class),
        OP_STARTS("starts", Starts.class),
        OP_FINISHES("finishes", Finishes.class),
        OP_ROUND("round", Round.class),
        OP_FLOOR("floor", Floor.class),
        OP_CEILING("ceiling", Ceiling.class),
        OP_GEO_DISTANCE("geo.distance", GeoDistance.class),
        OP_GEO_LENGTH("geo.length", GeoLength.class),
        OP_GEO_INTERSECTS("geo.intersects", GeoIntersects.class),
        OP_ST_EQUALS("st_equals", STEquals.class),
        OP_ST_DISJOINT("st_disjoint", STDisjoint.class),
        OP_ST_TOUCHES("st_touches", STTouches.class),
        OP_ST_WITHIN("st_within", STWithin.class),
        OP_ST_OVERLAPS("st_overlaps", STOverlaps.class),
        OP_ST_CROSSES("st_crosses", STCrosses.class),
        OP_ST_INTERSECTS("st_intersects", STIntersects.class),
        OP_ST_CONTAINS("st_contains", STContains.class),
        OP_ST_RELATE("st_relate", STRelate.class);

        private static final Map<String, Operator> BY_KEY;
        public final String urlKey;
        public final Class<? extends Function> implementingClass;

        private Operator(String urlKey, Class<? extends Function> implementingClass) {
            this.urlKey = urlKey;
            this.implementingClass = implementingClass;
        }

        public Function instantiate() {
            try {
                return this.implementingClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex2) {
                throw new IllegalStateException("problem executing '" + this + "'", ex2);
            }
        }

        public static Operator fromKey(String key) {
            Operator operator = BY_KEY.get(key);
            if (operator == null) {
                throw new IllegalArgumentException("Unknown operator: '" + key + "'.");
            }
            return operator;
        }

        static {
            BY_KEY = new HashMap<String, Operator>();
            for (Operator o2 : Operator.values()) {
                BY_KEY.put(o2.urlKey, o2);
            }
        }
    }
}

