/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.AbstractSubscription;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.SubscriptionFactory;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.QueryParser;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncorrectRequestException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySetSubscription
extends AbstractSubscription {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntitySetSubscription.class);
    private Query query;

    public EntitySetSubscription(CoreSettings settings, String topic, ResourcePath path) {
        super(topic, path, settings);
        this.init();
    }

    private void init() {
        this.entityType = ((PathElementEntitySet)this.path.getLastElement()).getEntityType();
        this.query = this.parseQuery(SubscriptionFactory.getQueryFromTopic(this.topic));
        if (this.query != null && (this.query.getCount().isPresent() || !this.query.getExpand().isEmpty() || this.query.getFilter() != null || !this.query.getOrderBy().isEmpty() || this.query.getSkip().isPresent() || this.query.getTop().isPresent())) {
            throw new IllegalArgumentException("Invalid subscription to: '" + this.topic + "': only $select is allowed in query options.");
        }
        this.generateFilter(1);
    }

    private Query parseQuery(String topic) {
        String queryString = null;
        try {
            queryString = URLDecoder.decode(topic, StringHelper.UTF8.name());
        }
        catch (UnsupportedEncodingException ex2) {
            LOGGER.error("Unsupported encoding.", ex2);
        }
        try {
            return QueryParser.parseQuery(queryString, this.queryDefaults, this.modelRegistry, this.path).validate();
        }
        catch (IllegalArgumentException e2) {
            LOGGER.error("Invalid query: {} ERROR: {}", (Object)queryString, (Object)e2.getMessage());
            return null;
        }
    }

    @Override
    public String doFormatMessage(Entity entity) throws IOException {
        try {
            entity.setQuery(this.query);
            return this.settings.getFormatter(this.query.getVersion(), "default").format(this.path, this.query, entity, true).getFormatted();
        }
        catch (IncorrectRequestException ex2) {
            throw new IllegalArgumentException(ex2);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.query);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        EntitySetSubscription other = (EntitySetSubscription)obj;
        return Objects.equals(this.query, other.query);
    }
}

