/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.mqtt;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.MqttManager;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.SubscriptionSet;
import de.fraunhofer.iosb.ilt.frostserver.mqtt.subscription.Subscription;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionSetDirectParent {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionSetDirectParent.class.getName());
    private final MqttManager mqttManager;
    private final NavigationPropertyMain relationToParent;
    private final Map<Id, SubscriptionSet> subscriptions = new ConcurrentHashMap<Id, SubscriptionSet>();
    private final AtomicInteger topicCount;

    public SubscriptionSetDirectParent(MqttManager mqttManager, NavigationPropertyMain relationToParent, AtomicInteger topicCount) {
        this.mqttManager = mqttManager;
        this.relationToParent = relationToParent;
        this.topicCount = topicCount;
    }

    public void handleEntityChanged(PersistenceManager persistenceManager, Entity entity, Set<Property> fields2) {
        Entity parent = (Entity)entity.getProperty(this.relationToParent);
        if (parent == null) {
            return;
        }
        Id parentId = parent.getId();
        SubscriptionSet subsForParent = this.subscriptions.get(parentId);
        if (subsForParent == null) {
            return;
        }
        for (Subscription subscription : subsForParent.getSubscriptions().keySet()) {
            if (!subscription.matches(persistenceManager, entity, fields2)) continue;
            this.mqttManager.notifySubscription(subscription, entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubscription(Subscription subscription) {
        SubscriptionSetDirectParent subscriptionSetDirectParent = this;
        synchronized (subscriptionSetDirectParent) {
            NavigationPropertyMain parentRelation = subscription.getParentRelation();
            Id parentId = subscription.getParentId();
            if (parentRelation == null || parentId == null) {
                LOGGER.error("Parent Relation or ParentId is null! {} / {}", (Object)parentRelation, (Object)parentId);
                return false;
            }
            SubscriptionSet subsForParent = this.subscriptions.computeIfAbsent(parentId, t2 -> new SubscriptionSet(this.topicCount));
            subsForParent.addSubscription(subscription);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(Subscription subscription) {
        SubscriptionSetDirectParent subscriptionSetDirectParent = this;
        synchronized (subscriptionSetDirectParent) {
            NavigationPropertyMain parentRelation = subscription.getParentRelation();
            Id parentId = subscription.getParentId();
            if (parentRelation == null || parentId == null) {
                LOGGER.error("Parent Relation or ParentId is null! {} / {}", (Object)parentRelation, (Object)parentId);
                return;
            }
            SubscriptionSet subsForParent = this.subscriptions.get(parentId);
            if (subsForParent == null) {
                return;
            }
            subsForParent.removeSubscription(subscription);
        }
    }
}

