/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model.core.annotations;

import de.fraunhofer.iosb.ilt.configurable.AnnotatedConfigurable;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.SourceNamespaceName;

public abstract class AbstractAnnotation<T extends AbstractAnnotation>
implements Annotation,
AnnotatedConfigurable<Void, Void> {
    @ConfigurableField(editor=EditorString.class, label="BaseUrl", description="The base URL defining the annotation, without file-extension.")
    @EditorString.EdOptsString
    private String sourceUrlBase;
    @ConfigurableField(editor=EditorString.class, label="NameSpace", description="The Namespace of the annotation.")
    @EditorString.EdOptsString
    private String nameSpace;
    @ConfigurableField(editor=EditorString.class, label="Name", description="The Name of the annotation.")
    @EditorString.EdOptsString
    private String name;

    protected AbstractAnnotation() {
    }

    protected AbstractAnnotation(SourceNamespaceName snn) {
        this.sourceUrlBase = snn.getSourceUrlBase();
        this.nameSpace = snn.getNameSpace();
        this.name = snn.getName();
    }

    @Override
    public final String getSourceUrl(Annotation.DocType docType) {
        return this.sourceUrlBase + "." + docType.getDefaultExtension();
    }

    public final T setSourceUrlBase(String sourceUrlBase) {
        this.sourceUrlBase = sourceUrlBase;
        return this.getThis();
    }

    @Override
    public final String getNameSpace() {
        return this.nameSpace;
    }

    public final T setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this.getThis();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final T setName(String name) {
        this.name = name;
        return this.getThis();
    }

    public abstract T getThis();
}

