/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.model;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySetImpl;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.query.expression.Path;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DefaultEntity
implements Entity {
    private EntityType entityType;
    private final Map<EntityPropertyMain, Object> entityProperties = new HashMap<EntityPropertyMain, Object>();
    private final Map<NavigationPropertyMain, Object> navProperties = new HashMap<NavigationPropertyMain, Object>();
    private final Set<Property> setProperties = new HashSet<Property>();
    private Query query;
    private String selfLink;

    public DefaultEntity(EntityType entityType) {
        this.entityType = entityType;
    }

    public DefaultEntity(EntityType entityType, Id id2) {
        this.entityType = entityType;
        this.setId(id2);
    }

    @Override
    public final Id getId() {
        return this.getProperty(this.entityType.getPrimaryKey());
    }

    @Override
    public final DefaultEntity setId(Id id2) {
        this.entityProperties.put(this.entityType.getPrimaryKey(), id2);
        this.setProperties.add(this.entityType.getPrimaryKey());
        return this;
    }

    @Override
    public String getSelfLink() {
        if (this.selfLink == null && this.query != null) {
            this.selfLink = UrlHelper.generateSelfLink(this.query, this.query.getPath(), this);
        }
        return this.selfLink;
    }

    @Override
    public DefaultEntity setSelfLink(String selfLink) {
        this.selfLink = selfLink;
        return this;
    }

    @Override
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public DefaultEntity setEntityType(EntityType entityType) {
        if (this.entityType != null) {
            throw new IllegalArgumentException("the type of this entity is alread yet to " + this.entityType.entityName);
        }
        this.entityType = entityType;
        return this;
    }

    @Override
    public boolean isSetProperty(Property property) {
        if (property == ModelRegistry.EP_SELFLINK) {
            return true;
        }
        return this.setProperties.contains(property);
    }

    @Override
    public <P> P getProperty(Property<P> property) {
        if (property == ModelRegistry.EP_SELFLINK) {
            return (P)this.getSelfLink();
        }
        if (property instanceof EntityPropertyMain) {
            EntityPropertyMain entityPropertyMain = (EntityPropertyMain)property;
            return (P)this.entityProperties.get(entityPropertyMain);
        }
        if (property instanceof NavigationPropertyMain) {
            NavigationPropertyMain navigationPropertyMain = (NavigationPropertyMain)property;
            return (P)this.navProperties.get(navigationPropertyMain);
        }
        return property.getFrom(this);
    }

    @Override
    public Object getProperty(Path path) {
        DefaultEntity result = this;
        for (Property element : path.getElements()) {
            if (result instanceof Entity) {
                result = element.getFrom(result);
                continue;
            }
            if (result instanceof Map) {
                result = ((Map)((Object)result)).get(element.getName());
                continue;
            }
            if (result instanceof List) {
                try {
                    int idx = Integer.parseInt(element.getName());
                    result = ((List)((Object)result)).get(idx);
                    continue;
                }
                catch (NumberFormatException exc) {
                    return null;
                }
            }
            return null;
        }
        return result;
    }

    @Override
    public <P> DefaultEntity setProperty(Property<P> property, P value) {
        if (property == ModelRegistry.EP_SELFLINK) {
            this.setSelfLink(String.valueOf(value));
        } else if (property instanceof EntityPropertyMain) {
            this.entityProperties.put((EntityPropertyMain)property, value);
            this.setProperties.add(property);
        } else if (property instanceof NavigationPropertyMain) {
            this.navProperties.put((NavigationPropertyMain)property, value);
            if (value == null) {
                this.setProperties.remove(property);
            } else {
                this.setProperties.add(property);
            }
        }
        return this;
    }

    @Override
    public DefaultEntity unsetProperty(Property property) {
        if (property instanceof EntityPropertyMain) {
            EntityPropertyMain entityPropertyMain = (EntityPropertyMain)property;
            this.entityProperties.remove(entityPropertyMain);
        } else if (property instanceof NavigationPropertyMain) {
            NavigationPropertyMain navigationPropertyMain = (NavigationPropertyMain)property;
            this.navProperties.remove(navigationPropertyMain);
        }
        this.setProperties.add(property);
        return this;
    }

    @Override
    public DefaultEntity addNavigationEntity(Entity linkedEntity) {
        EntityType linkedType = linkedEntity.getEntityType();
        NavigationPropertyMain navProperty = this.entityType.getNavigationProperty(linkedType);
        if (navProperty instanceof NavigationPropertyMain.NavigationPropertyEntitySet) {
            return this.addNavigationEntity((NavigationPropertyMain.NavigationPropertyEntitySet)navProperty, linkedEntity);
        }
        throw new IllegalArgumentException("addNavigationEntity expects an entity type that goes into a set.");
    }

    @Override
    public DefaultEntity addNavigationEntity(NavigationPropertyMain.NavigationPropertyEntitySet navProperty, Entity linkedEntity) {
        EntitySet entitySet = this.getProperty(navProperty);
        if (entitySet == null) {
            entitySet = new EntitySetImpl(navProperty);
            this.setProperty((Property)navProperty, entitySet);
        }
        entitySet.add(linkedEntity);
        return this;
    }

    @Override
    public void setEntityPropertiesSet(boolean set, boolean entityPropertiesOnly) {
        if (!set) {
            this.setProperties.clear();
        } else {
            this.setProperties.addAll(this.entityType.getEntityProperties());
            if (!entityPropertiesOnly) {
                this.setProperties.addAll(this.entityType.getNavigationEntities());
            }
        }
    }

    @Override
    public void setEntityPropertiesSet(Entity comparedTo, EntityChangedMessage message) {
        this.setProperties.clear();
        for (EntityPropertyMain entityPropertyMain : this.entityType.getEntityProperties()) {
            if (Objects.equals(this.getProperty(entityPropertyMain), comparedTo.getProperty(entityPropertyMain))) continue;
            this.setProperties.add(entityPropertyMain);
            message.addEpField(entityPropertyMain);
        }
        for (NavigationPropertyMain navigationPropertyMain : this.entityType.getNavigationEntities()) {
            if (Objects.equals(this.getProperty(navigationPropertyMain), comparedTo.getProperty(navigationPropertyMain))) continue;
            this.setProperties.add(navigationPropertyMain);
            message.addNpField(navigationPropertyMain);
        }
    }

    @Override
    public void complete(PathElementEntitySet containingSet) throws IncompleteEntityException {
        this.entityType.complete((Entity)this, containingSet);
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public DefaultEntity setQuery(Query query) {
        this.query = query;
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.entityProperties.get(this.entityType.getPrimaryKey()) != null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultEntity other = (DefaultEntity)obj;
        if (!Objects.equals(this.entityType, other.entityType)) {
            return false;
        }
        if (!Objects.equals(this.entityProperties, other.entityProperties)) {
            return false;
        }
        return Objects.equals(this.navProperties, other.navProperties);
    }

    public int hashCode() {
        return Objects.hash(this.entityType, this.entityProperties, this.navProperties);
    }

    public String toString() {
        return "Entity: " + this.entityType;
    }
}

