/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.json.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import java.io.IOException;

public class EntityChangedMessageSerializer
extends JsonSerializer<EntityChangedMessage> {
    @Override
    public void serialize(EntityChangedMessage message, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        EntityType entityType;
        gen.writeStartObject();
        EntityChangedMessage.Type eventType = message.getEventType();
        if (eventType != null) {
            gen.writeStringField("eventType", eventType.name());
        }
        if ((entityType = message.getEntityType()) != null) {
            gen.writeStringField("entityType", entityType.entityName);
        }
        gen.writeObjectField("entity", message.getEntity());
        gen.writeObjectField("epFields", message.getEpFields());
        gen.writeObjectField("npFields", message.getNpFields());
        gen.writeEndObject();
    }
}

