/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom.CustomDeserializationManager;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom.CustomDeserializer;
import de.fraunhofer.iosb.ilt.frostserver.model.DefaultEntity;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySetImpl;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.util.ParserUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CustomEntityDeserializer
extends JsonDeserializer<Entity> {
    private static final Map<ModelRegistry, Map<EntityType, CustomEntityDeserializer>> instancePerModelAndType = new HashMap<ModelRegistry, Map<EntityType, CustomEntityDeserializer>>();
    private final EntityType entityType;
    private final ModelRegistry modelRegistry;
    private final Map<String, PropertyData> propertyByName = new HashMap<String, PropertyData>();

    public static CustomEntityDeserializer getInstance(ModelRegistry modelRegistry, EntityType entityType) {
        return instancePerModelAndType.computeIfAbsent(modelRegistry, t2 -> new HashMap()).computeIfAbsent(entityType, t2 -> new CustomEntityDeserializer(modelRegistry, (EntityType)t2));
    }

    public CustomEntityDeserializer(ModelRegistry modelRegistry, EntityType entityType) {
        this.modelRegistry = modelRegistry;
        this.entityType = entityType;
        Set<Property> propertySet = entityType.getPropertySet();
        for (Property property : propertySet) {
            if (property instanceof EntityPropertyMain) {
                PropertyData propertyData = new PropertyData(property, property.getType().getTypeReference(), false, null);
                for (String alias : ((EntityPropertyMain)property).getAliases()) {
                    this.propertyByName.put(alias, propertyData);
                }
                continue;
            }
            if (!(property instanceof NavigationPropertyMain)) continue;
            NavigationPropertyMain np2 = (NavigationPropertyMain)property;
            this.propertyByName.put(property.getJsonName(), new PropertyData(property, null, np2.isEntitySet(), np2.getEntityType()));
        }
    }

    public Entity deserializeFull(JsonParser parser, DeserializationContext ctxt) throws IOException {
        parser.nextToken();
        Entity result = this.deserialize(parser, ctxt);
        parser.nextToken();
        return result;
    }

    @Override
    public Entity deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        DefaultEntity result = new DefaultEntity(this.entityType);
        boolean failOnUnknown = ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        DelayedField delayedField = null;
        JsonToken currentToken = parser.nextToken();
        while (currentToken == JsonToken.FIELD_NAME) {
            String fieldName = parser.getCurrentName();
            parser.nextValue();
            PropertyData propertyData = this.propertyByName.get(fieldName);
            if (propertyData == null) {
                if (failOnUnknown) {
                    throw new UnrecognizedPropertyException(parser, "Unknown field: " + fieldName, parser.getCurrentLocation(), DefaultEntity.class, fieldName, null);
                }
                parser.readValueAsTree();
            } else {
                delayedField = this.deserializeProperty(parser, ctxt, result, propertyData, delayedField);
            }
            currentToken = parser.nextToken();
        }
        if (delayedField != null) {
            EntityPropertyMain entityPropertyMain = delayedField.entityPropertyMain;
            String encodingType = result.getProperty(ModelRegistry.EP_ENCODINGTYPE);
            if (encodingType == null) {
                entityPropertyMain.setOn(result, delayedField.tempValue);
            } else {
                CustomDeserializer deserializer = CustomDeserializationManager.getInstance().getDeserializer(encodingType.toString());
                Object value = deserializer.deserialize(delayedField.tempValue);
                entityPropertyMain.setOn(result, value);
            }
        }
        return result;
    }

    private DelayedField deserializeProperty(JsonParser parser, DeserializationContext ctxt, Entity result, PropertyData propertyData, DelayedField delayedField) throws IOException {
        if (propertyData.property instanceof EntityPropertyMain) {
            delayedField = this.deserializeEntityProperty(parser, ctxt, propertyData, result, delayedField);
        } else if (propertyData.property instanceof NavigationPropertyMain) {
            this.deserializeNavigationProperty(propertyData, result, parser, ctxt);
        }
        return delayedField;
    }

    private void deserializeNavigationProperty(PropertyData propertyData, Entity result, JsonParser parser, DeserializationContext ctxt) throws IOException {
        NavigationPropertyMain navPropertyMain = (NavigationPropertyMain)propertyData.property;
        if (propertyData.isEntitySet) {
            this.deserialiseEntitySet(parser, ctxt, (NavigationPropertyMain.NavigationPropertyEntitySet)navPropertyMain, result);
        } else {
            EntityType targetEntityType = navPropertyMain.getEntityType();
            Entity value = CustomEntityDeserializer.getInstance(this.modelRegistry, targetEntityType).deserialize(parser, ctxt);
            navPropertyMain.setOn(result, value);
        }
    }

    private DelayedField deserializeEntityProperty(JsonParser parser, DeserializationContext ctxt, PropertyData propertyData, Entity result, DelayedField delayedField) throws IOException {
        EntityPropertyMain entityPropertyMain = (EntityPropertyMain)propertyData.property;
        if (propertyData.valueTypeRef == null) {
            String encodingType = ModelRegistry.EP_ENCODINGTYPE.getFrom(result);
            if (encodingType == null) {
                delayedField = new DelayedField(entityPropertyMain, (TreeNode)parser.readValueAsTree());
            } else {
                CustomDeserializer deserializer = CustomDeserializationManager.getInstance().getDeserializer(encodingType.toString());
                Object value = deserializer.deserialize(parser, ctxt);
                entityPropertyMain.setOn(result, value);
            }
        } else if (propertyData.property == this.entityType.getPrimaryKey()) {
            Object value = parser.readValueAs(propertyData.valueTypeRef);
            entityPropertyMain.setOn(result, ParserUtils.idFromObject(value));
        } else {
            Object value = parser.readValueAs(propertyData.valueTypeRef);
            entityPropertyMain.setOn(result, value);
        }
        return delayedField;
    }

    private void deserialiseEntitySet(JsonParser parser, DeserializationContext ctxt, NavigationPropertyMain.NavigationPropertyEntitySet navPropertyMain, Entity result) throws IOException {
        EntityType setType = navPropertyMain.getEntityType();
        EntitySetImpl entitySet = new EntitySetImpl(navPropertyMain);
        CustomEntityDeserializer setEntityDeser = CustomEntityDeserializer.getInstance(this.modelRegistry, setType);
        result.setProperty(navPropertyMain, entitySet);
        JsonToken curToken = parser.nextToken();
        while (curToken != null && curToken != JsonToken.END_ARRAY) {
            entitySet.add(setEntityDeser.deserialize(parser, ctxt));
            curToken = parser.nextToken();
        }
    }

    private static class PropertyData {
        final Property property;
        final TypeReference valueTypeRef;
        final boolean isEntitySet;
        final EntityType setType;

        public PropertyData(Property property, TypeReference valueTypeRef, boolean isEntitySet, EntityType setType) {
            this.property = property;
            this.valueTypeRef = valueTypeRef;
            this.isEntitySet = isEntitySet;
            this.setType = setType;
        }
    }

    private static class DelayedField {
        public final EntityPropertyMain entityPropertyMain;
        public final TreeNode tempValue;

        public DelayedField(EntityPropertyMain entityPropertyMain, TreeNode tempValue) {
            this.entityPropertyMain = entityPropertyMain;
            this.tempValue = tempValue;
        }
    }
}

