/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.json.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeValue;
import java.io.IOException;

public class TimeValueDeserializer
extends StdDeserializer<TimeValue> {
    public TimeValueDeserializer() {
        super(TimeValue.class);
    }

    @Override
    public TimeValue deserialize(JsonParser jp2, DeserializationContext dc2) throws IOException {
        String node = jp2.getValueAsString();
        if (node == null) {
            return null;
        }
        try {
            return new TimeValue(TimeInstant.parse(node));
        }
        catch (IllegalArgumentException e2) {
            return new TimeValue(TimeInterval.parse(node));
        }
    }
}

