/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.swing;

import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

public final class FactoryColorSwing
implements GuiFactorySwing {
    private final EditorColor parentEditor;
    private JPanel swComponent;
    private SpinnerNumberModel swModelAlpha;
    private SpinnerNumberModel swModelBlue;
    private SpinnerNumberModel swModelGreen;
    private SpinnerNumberModel swModelRed;
    private boolean filling = false;

    public FactoryColorSwing(EditorColor parentEditor) {
        this.parentEditor = parentEditor;
    }

    @Override
    public JComponent getComponent() {
        if (this.swComponent == null) {
            this.createComponent();
        }
        return this.swComponent;
    }

    private void createComponent() {
        this.swModelAlpha = new SpinnerNumberModel(0, 0, 255, 1);
        this.swModelBlue = new SpinnerNumberModel(0, 0, 255, 1);
        this.swModelGreen = new SpinnerNumberModel(0, 0, 255, 1);
        this.swModelRed = new SpinnerNumberModel(0, 0, 255, 1);
        this.swComponent = new JPanel(new GridBagLayout());
        this.swComponent.add((Component)new JSpinner(this.swModelRed), new GridBagConstraints());
        this.swComponent.add((Component)new JSpinner(this.swModelGreen), new GridBagConstraints());
        this.swComponent.add((Component)new JSpinner(this.swModelBlue), new GridBagConstraints());
        if (this.parentEditor.isEditAlpla()) {
            this.swComponent.add((Component)new JSpinner(this.swModelAlpha), new GridBagConstraints());
        }
        JButton button = new JButton("\u2026");
        button.setMargin(new Insets(0, 2, 0, 2));
        button.addActionListener(e2 -> this.openPicker());
        this.swComponent.add((Component)button, new GridBagConstraints());
        this.fillComponent();
        ChangeListener cl2 = e2 -> {
            this.readComponent();
            this.swComponent.setBackground(new Color(this.parentEditor.getRed(), this.parentEditor.getGreen(), this.parentEditor.getBlue()));
        };
        this.swModelRed.addChangeListener(cl2);
        this.swModelGreen.addChangeListener(cl2);
        this.swModelBlue.addChangeListener(cl2);
        this.swModelAlpha.addChangeListener(cl2);
    }

    private void openPicker() {
        Color newColor = JColorChooser.showDialog(this.swComponent, "Choose Color", new Color(this.parentEditor.getRed(), this.parentEditor.getGreen(), this.parentEditor.getBlue(), this.parentEditor.getAlpha()));
        if (newColor != null) {
            this.parentEditor.setRed(newColor.getRed());
            this.parentEditor.setGreen(newColor.getGreen());
            this.parentEditor.setBlue(newColor.getBlue());
            if (this.parentEditor.isEditAlpla()) {
                this.parentEditor.setAlpha(newColor.getAlpha());
            }
        }
        this.fillComponent();
    }

    public void fillComponent() {
        this.filling = true;
        this.swModelRed.setValue(this.parentEditor.getRed());
        this.swModelGreen.setValue(this.parentEditor.getGreen());
        this.swModelBlue.setValue(this.parentEditor.getBlue());
        if (this.parentEditor.isEditAlpla()) {
            this.swModelAlpha.setValue(this.parentEditor.getAlpha());
        }
        this.swComponent.setBackground(new Color(this.parentEditor.getRed(), this.parentEditor.getGreen(), this.parentEditor.getBlue()));
        this.filling = false;
    }

    public void readComponent() {
        if (this.filling) {
            return;
        }
        this.parentEditor.setRed(this.swModelRed.getNumber().intValue());
        this.parentEditor.setGreen(this.swModelGreen.getNumber().intValue());
        this.parentEditor.setBlue(this.swModelBlue.getNumber().intValue());
        this.parentEditor.setAlpha(this.swModelAlpha.getNumber().intValue());
    }
}

