/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.fx;

import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorColor;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.paint.Color;

public final class FactoryColorFx
implements GuiFactoryFx {
    private final EditorColor parentEditor;
    private ColorPicker fxNode;

    public FactoryColorFx(EditorColor parentEditor) {
        this.parentEditor = parentEditor;
    }

    @Override
    public Node getNode() {
        if (this.fxNode == null) {
            this.createNode();
        }
        return this.fxNode;
    }

    private void createNode() {
        this.fxNode = new ColorPicker();
        this.fxNode.setOnAction(event -> this.readComponent());
        this.fillComponent();
    }

    public void fillComponent() {
        Color color = Color.color((double)this.parentEditor.getRed() / 255.0, (double)this.parentEditor.getGreen() / 255.0, (double)this.parentEditor.getBlue() / 255.0, (double)(255 - this.parentEditor.getAlpha()) / 255.0);
        this.fxNode.setValue(color);
    }

    public void readComponent() {
        Color color = (Color)this.fxNode.getValue();
        this.parentEditor.setRed((int)(color.getRed() * 255.0));
        this.parentEditor.setGreen((int)(color.getGreen() * 255.0));
        this.parentEditor.setBlue((int)(color.getBlue() * 255.0));
        this.parentEditor.setAlpha((int)((1.0 - color.getOpacity()) * 255.0));
    }
}

