/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor;

import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import java.awt.Component;
import java.awt.Insets;
import java.lang.reflect.Field;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;

public abstract class EditorDefault<T>
implements ConfigEditor<T> {
    private String label = "";
    private String description = "";
    private static JFrame helpFrame;
    private static JTextPane textPane;

    @Override
    public void initFor(Field field) {
        throw new UnsupportedOperationException("Not supported yet for " + this.getClass().getName());
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public JButton getHelpButton() {
        JButton button = new JButton("?");
        button.setMargin(new Insets(0, 0, 0, 0));
        button.addActionListener(e2 -> this.popupDescription());
        return button;
    }

    public void popupDescription() {
        EditorDefault.getHelpFrame();
        textPane.setText("<html><body>" + this.description + "</body></html>");
        helpFrame.setSize(400, 600);
        helpFrame.setVisible(true);
    }

    public static JFrame getHelpFrame() {
        if (helpFrame == null) {
            helpFrame = new JFrame("Help");
            helpFrame.setDefaultCloseOperation(1);
            JScrollPane jScrollPane1 = new JScrollPane();
            textPane = new JTextPane();
            textPane.setEditorKit(new HTMLEditorKit());
            jScrollPane1.setViewportView(textPane);
            helpFrame.getContentPane().add((Component)jScrollPane1, "Center");
        }
        return helpFrame;
    }
}

