/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable;

import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.annotations.AnnotationHelper;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigEditors {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigEditors.class);

    private ConfigEditors() {
    }

    public static <R, E> Optional<ConfigEditor<?>> buildEditorFromClass(Class<?> subclassType, R runtimeContext, E editorContext) {
        if (Arrays.stream(subclassType.getMethods()).filter(method -> "getClassConfigEditor".equals(method.getName())).findAny().isPresent()) {
            try {
                return Optional.of((ConfigEditor)ConfigEditor.class.cast(MethodUtils.invokeStaticMethod(subclassType, "getClassConfigEditor", runtimeContext, editorContext)));
            }
            catch (ClassCastException | ReflectiveOperationException exc) {
                LOGGER.debug("Exception on attempt to build singleton class editor via static factory method.", exc);
            }
        }
        return Optional.ofNullable(AnnotationHelper.generateEditorFromAnnotations(subclassType, runtimeContext, editorContext).orElse(null));
    }
}

