/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.simplify;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.simplify.TaggedLineSegment;
import java.util.ArrayList;
import java.util.List;

class TaggedLineString {
    private LineString parentLine;
    private TaggedLineSegment[] segs;
    private List resultSegs = new ArrayList();
    private int minimumSize;

    public TaggedLineString(LineString parentLine) {
        this(parentLine, 2);
    }

    public TaggedLineString(LineString parentLine, int minimumSize) {
        this.parentLine = parentLine;
        this.minimumSize = minimumSize;
        this.init();
    }

    public int getMinimumSize() {
        return this.minimumSize;
    }

    public LineString getParent() {
        return this.parentLine;
    }

    public Coordinate[] getParentCoordinates() {
        return this.parentLine.getCoordinates();
    }

    public Coordinate[] getResultCoordinates() {
        return TaggedLineString.extractCoordinates(this.resultSegs);
    }

    public int getResultSize() {
        int resultSegsSize = this.resultSegs.size();
        return resultSegsSize == 0 ? 0 : resultSegsSize + 1;
    }

    public TaggedLineSegment getSegment(int i2) {
        return this.segs[i2];
    }

    private void init() {
        Coordinate[] pts = this.parentLine.getCoordinates();
        this.segs = new TaggedLineSegment[pts.length - 1];
        for (int i2 = 0; i2 < pts.length - 1; ++i2) {
            TaggedLineSegment seg;
            this.segs[i2] = seg = new TaggedLineSegment(pts[i2], pts[i2 + 1], this.parentLine, i2);
        }
    }

    public TaggedLineSegment[] getSegments() {
        return this.segs;
    }

    public void addToResult(LineSegment seg) {
        this.resultSegs.add(seg);
    }

    public LineString asLineString() {
        return this.parentLine.getFactory().createLineString(TaggedLineString.extractCoordinates(this.resultSegs));
    }

    public LinearRing asLinearRing() {
        return this.parentLine.getFactory().createLinearRing(TaggedLineString.extractCoordinates(this.resultSegs));
    }

    private static Coordinate[] extractCoordinates(List segs) {
        Coordinate[] pts = new Coordinate[segs.size() + 1];
        LineSegment seg = null;
        for (int i2 = 0; i2 < segs.size(); ++i2) {
            seg = (LineSegment)segs.get(i2);
            pts[i2] = seg.p0;
        }
        pts[pts.length - 1] = seg.p1;
        return pts;
    }
}

