/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.polygonize;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.polygonize.EdgeRing;
import com.vividsolutions.jts.operation.polygonize.PolygonizeDirectedEdge;
import com.vividsolutions.jts.operation.polygonize.PolygonizeEdge;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import com.vividsolutions.jts.planargraph.DirectedEdgeStar;
import com.vividsolutions.jts.planargraph.Node;
import com.vividsolutions.jts.planargraph.PlanarGraph;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

class PolygonizeGraph
extends PlanarGraph {
    private GeometryFactory factory;

    private static int getDegreeNonDeleted(Node node) {
        List edges = node.getOutEdges().getEdges();
        int degree = 0;
        for (PolygonizeDirectedEdge de2 : edges) {
            if (de2.isMarked()) continue;
            ++degree;
        }
        return degree;
    }

    private static int getDegree(Node node, long label) {
        List edges = node.getOutEdges().getEdges();
        int degree = 0;
        for (PolygonizeDirectedEdge de2 : edges) {
            if (de2.getLabel() != label) continue;
            ++degree;
        }
        return degree;
    }

    public static void deleteAllEdges(Node node) {
        List edges = node.getOutEdges().getEdges();
        for (PolygonizeDirectedEdge de2 : edges) {
            de2.setMarked(true);
            PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)de2.getSym();
            if (sym == null) continue;
            sym.setMarked(true);
        }
    }

    public PolygonizeGraph(GeometryFactory factory) {
        this.factory = factory;
    }

    public void addEdge(LineString line) {
        if (line.isEmpty()) {
            return;
        }
        Coordinate[] linePts = CoordinateArrays.removeRepeatedPoints(line.getCoordinates());
        if (linePts.length < 2) {
            return;
        }
        Coordinate startPt = linePts[0];
        Coordinate endPt = linePts[linePts.length - 1];
        Node nStart = this.getNode(startPt);
        Node nEnd = this.getNode(endPt);
        PolygonizeDirectedEdge de0 = new PolygonizeDirectedEdge(nStart, nEnd, linePts[1], true);
        PolygonizeDirectedEdge de1 = new PolygonizeDirectedEdge(nEnd, nStart, linePts[linePts.length - 2], false);
        PolygonizeEdge edge = new PolygonizeEdge(line);
        edge.setDirectedEdges(de0, de1);
        this.add(edge);
    }

    private Node getNode(Coordinate pt2) {
        Node node = this.findNode(pt2);
        if (node == null) {
            node = new Node(pt2);
            this.add(node);
        }
        return node;
    }

    private void computeNextCWEdges() {
        Iterator iNode = this.nodeIterator();
        while (iNode.hasNext()) {
            Node node = (Node)iNode.next();
            PolygonizeGraph.computeNextCWEdges(node);
        }
    }

    private void convertMaximalToMinimalEdgeRings(List ringEdges) {
        for (PolygonizeDirectedEdge de2 : ringEdges) {
            long label;
            List intNodes = PolygonizeGraph.findIntersectionNodes(de2, label = de2.getLabel());
            if (intNodes == null) continue;
            for (Node node : intNodes) {
                PolygonizeGraph.computeNextCCWEdges(node, label);
            }
        }
    }

    private static List findIntersectionNodes(PolygonizeDirectedEdge startDE, long label) {
        PolygonizeDirectedEdge de2 = startDE;
        ArrayList<Node> intNodes = null;
        do {
            Node node;
            if (PolygonizeGraph.getDegree(node = de2.getFromNode(), label) > 1) {
                if (intNodes == null) {
                    intNodes = new ArrayList<Node>();
                }
                intNodes.add(node);
            }
            Assert.isTrue((de2 = de2.getNext()) != null, "found null DE in ring");
            Assert.isTrue(de2 == startDE || !de2.isInRing(), "found DE already in ring");
        } while (de2 != startDE);
        return intNodes;
    }

    public List getEdgeRings() {
        this.computeNextCWEdges();
        PolygonizeGraph.label(this.dirEdges, -1L);
        List maximalRings = PolygonizeGraph.findLabeledEdgeRings(this.dirEdges);
        this.convertMaximalToMinimalEdgeRings(maximalRings);
        ArrayList<EdgeRing> edgeRingList = new ArrayList<EdgeRing>();
        for (PolygonizeDirectedEdge de2 : this.dirEdges) {
            if (de2.isMarked() || de2.isInRing()) continue;
            EdgeRing er2 = this.findEdgeRing(de2);
            edgeRingList.add(er2);
        }
        return edgeRingList;
    }

    private static List findLabeledEdgeRings(Collection dirEdges) {
        ArrayList<PolygonizeDirectedEdge> edgeRingStarts = new ArrayList<PolygonizeDirectedEdge>();
        long currLabel = 1L;
        for (PolygonizeDirectedEdge de2 : dirEdges) {
            if (de2.isMarked() || de2.getLabel() >= 0L) continue;
            edgeRingStarts.add(de2);
            List edges = PolygonizeGraph.findDirEdgesInRing(de2);
            PolygonizeGraph.label(edges, currLabel);
            ++currLabel;
        }
        return edgeRingStarts;
    }

    public List deleteCutEdges() {
        this.computeNextCWEdges();
        PolygonizeGraph.findLabeledEdgeRings(this.dirEdges);
        ArrayList<LineString> cutLines = new ArrayList<LineString>();
        for (PolygonizeDirectedEdge de2 : this.dirEdges) {
            if (de2.isMarked()) continue;
            PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)de2.getSym();
            if (de2.getLabel() != sym.getLabel()) continue;
            de2.setMarked(true);
            sym.setMarked(true);
            PolygonizeEdge e2 = (PolygonizeEdge)de2.getEdge();
            cutLines.add(e2.getLine());
        }
        return cutLines;
    }

    private static void label(Collection dirEdges, long label) {
        for (PolygonizeDirectedEdge de2 : dirEdges) {
            de2.setLabel(label);
        }
    }

    private static void computeNextCWEdges(Node node) {
        DirectedEdgeStar deStar = node.getOutEdges();
        PolygonizeDirectedEdge startDE = null;
        DirectedEdge prevDE = null;
        for (PolygonizeDirectedEdge outDE : deStar.getEdges()) {
            if (outDE.isMarked()) continue;
            if (startDE == null) {
                startDE = outDE;
            }
            if (prevDE != null) {
                PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)prevDE.getSym();
                sym.setNext(outDE);
            }
            prevDE = outDE;
        }
        if (prevDE != null) {
            PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)prevDE.getSym();
            sym.setNext(startDE);
        }
    }

    private static void computeNextCCWEdges(Node node, long label) {
        DirectedEdgeStar deStar = node.getOutEdges();
        PolygonizeDirectedEdge firstOutDE = null;
        PolygonizeDirectedEdge prevInDE = null;
        List edges = deStar.getEdges();
        for (int i2 = edges.size() - 1; i2 >= 0; --i2) {
            PolygonizeDirectedEdge de2 = (PolygonizeDirectedEdge)edges.get(i2);
            PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)de2.getSym();
            PolygonizeDirectedEdge outDE = null;
            if (de2.getLabel() == label) {
                outDE = de2;
            }
            PolygonizeDirectedEdge inDE = null;
            if (sym.getLabel() == label) {
                inDE = sym;
            }
            if (outDE == null && inDE == null) continue;
            if (inDE != null) {
                prevInDE = inDE;
            }
            if (outDE == null) continue;
            if (prevInDE != null) {
                prevInDE.setNext(outDE);
                prevInDE = null;
            }
            if (firstOutDE != null) continue;
            firstOutDE = outDE;
        }
        if (prevInDE != null) {
            Assert.isTrue(firstOutDE != null);
            prevInDE.setNext(firstOutDE);
        }
    }

    private static List findDirEdgesInRing(PolygonizeDirectedEdge startDE) {
        PolygonizeDirectedEdge de2 = startDE;
        ArrayList<PolygonizeDirectedEdge> edges = new ArrayList<PolygonizeDirectedEdge>();
        do {
            edges.add(de2);
            de2 = de2.getNext();
            Assert.isTrue(de2 != null, "found null DE in ring");
            Assert.isTrue(de2 == startDE || !de2.isInRing(), "found DE already in ring");
        } while (de2 != startDE);
        return edges;
    }

    private EdgeRing findEdgeRing(PolygonizeDirectedEdge startDE) {
        PolygonizeDirectedEdge de2 = startDE;
        EdgeRing er2 = new EdgeRing(this.factory);
        do {
            er2.add(de2);
            de2.setRing(er2);
            de2 = de2.getNext();
            Assert.isTrue(de2 != null, "found null DE in ring");
            Assert.isTrue(de2 == startDE || !de2.isInRing(), "found DE already in ring");
        } while (de2 != startDE);
        return er2;
    }

    public Collection deleteDangles() {
        List nodesToRemove = this.findNodesOfDegree(1);
        HashSet<LineString> dangleLines = new HashSet<LineString>();
        Stack nodeStack = new Stack();
        Iterator i2 = nodesToRemove.iterator();
        while (i2.hasNext()) {
            nodeStack.push(i2.next());
        }
        while (!nodeStack.isEmpty()) {
            Node node = (Node)nodeStack.pop();
            PolygonizeGraph.deleteAllEdges(node);
            List nodeOutEdges = node.getOutEdges().getEdges();
            for (PolygonizeDirectedEdge de2 : nodeOutEdges) {
                de2.setMarked(true);
                PolygonizeDirectedEdge sym = (PolygonizeDirectedEdge)de2.getSym();
                if (sym != null) {
                    sym.setMarked(true);
                }
                PolygonizeEdge e2 = (PolygonizeEdge)de2.getEdge();
                dangleLines.add(e2.getLine());
                Node toNode = de2.getToNode();
                if (PolygonizeGraph.getDegreeNonDeleted(toNode) != 1) continue;
                nodeStack.push(toNode);
            }
        }
        return dangleLines;
    }

    public void computeDepthParity() {
        PolygonizeDirectedEdge de2;
        while ((de2 = null) != null) {
            this.computeDepthParity(de2);
        }
        return;
    }

    private void computeDepthParity(PolygonizeDirectedEdge de2) {
    }
}

