/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import java.util.ArrayList;
import java.util.List;

public class PointBuilder {
    private OverlayOp op;
    private GeometryFactory geometryFactory;
    private List resultPointList = new ArrayList();

    public PointBuilder(OverlayOp op2, GeometryFactory geometryFactory, PointLocator ptLocator) {
        this.op = op2;
        this.geometryFactory = geometryFactory;
    }

    public List build(int opCode) {
        this.extractNonCoveredResultNodes(opCode);
        return this.resultPointList;
    }

    private void extractNonCoveredResultNodes(int opCode) {
        for (Node n2 : this.op.getGraph().getNodes()) {
            Label label;
            if (n2.isInResult() || n2.isIncidentEdgeInResult() || n2.getEdges().getDegree() != 0 && opCode != 1 || !OverlayOp.isResultOfOp(label = n2.getLabel(), opCode)) continue;
            this.filterCoveredNodeToPoint(n2);
        }
    }

    private void filterCoveredNodeToPoint(Node n2) {
        Coordinate coord = n2.getCoordinate();
        if (!this.op.isCoveredByLA(coord)) {
            Point pt2 = this.geometryFactory.createPoint(coord);
            this.resultPointList.add(pt2);
        }
    }
}

