/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance3d;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;

public class AxisPlaneCoordinateSequence
implements CoordinateSequence {
    private static int[] XY_INDEX = new int[]{0, 1};
    private static int[] XZ_INDEX = new int[]{0, 2};
    private static int[] YZ_INDEX = new int[]{1, 2};
    private CoordinateSequence seq;
    private int[] indexMap;

    public static CoordinateSequence projectToXY(CoordinateSequence seq) {
        return new AxisPlaneCoordinateSequence(seq, XY_INDEX);
    }

    public static CoordinateSequence projectToXZ(CoordinateSequence seq) {
        return new AxisPlaneCoordinateSequence(seq, XZ_INDEX);
    }

    public static CoordinateSequence projectToYZ(CoordinateSequence seq) {
        return new AxisPlaneCoordinateSequence(seq, YZ_INDEX);
    }

    private AxisPlaneCoordinateSequence(CoordinateSequence seq, int[] indexMap) {
        this.seq = seq;
        this.indexMap = indexMap;
    }

    public int getDimension() {
        return 2;
    }

    public Coordinate getCoordinate(int i2) {
        return this.getCoordinateCopy(i2);
    }

    public Coordinate getCoordinateCopy(int i2) {
        return new Coordinate(this.getX(i2), this.getY(i2), this.getZ(i2));
    }

    public void getCoordinate(int index, Coordinate coord) {
        coord.x = this.getOrdinate(index, 0);
        coord.y = this.getOrdinate(index, 1);
        coord.z = this.getOrdinate(index, 2);
    }

    public double getX(int index) {
        return this.getOrdinate(index, 0);
    }

    public double getY(int index) {
        return this.getOrdinate(index, 1);
    }

    public double getZ(int index) {
        return this.getOrdinate(index, 2);
    }

    public double getOrdinate(int index, int ordinateIndex) {
        if (ordinateIndex > 1) {
            return 0.0;
        }
        return this.seq.getOrdinate(index, this.indexMap[ordinateIndex]);
    }

    public int size() {
        return this.seq.size();
    }

    public void setOrdinate(int index, int ordinateIndex, double value) {
        throw new UnsupportedOperationException();
    }

    public Coordinate[] toCoordinateArray() {
        throw new UnsupportedOperationException();
    }

    public Envelope expandEnvelope(Envelope env) {
        throw new UnsupportedOperationException();
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }
}

