/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.util.Assert;
import java.util.List;

public class RightmostEdgeFinder {
    private int minIndex = -1;
    private Coordinate minCoord = null;
    private DirectedEdge minDe = null;
    private DirectedEdge orientedDe = null;

    public DirectedEdge getEdge() {
        return this.orientedDe;
    }

    public Coordinate getCoordinate() {
        return this.minCoord;
    }

    public void findEdge(List dirEdgeList) {
        for (DirectedEdge de2 : dirEdgeList) {
            if (!de2.isForward()) continue;
            this.checkForRightmostCoordinate(de2);
        }
        Assert.isTrue(this.minIndex != 0 || this.minCoord.equals(this.minDe.getCoordinate()), "inconsistency in rightmost processing");
        if (this.minIndex == 0) {
            this.findRightmostEdgeAtNode();
        } else {
            this.findRightmostEdgeAtVertex();
        }
        this.orientedDe = this.minDe;
        int rightmostSide = this.getRightmostSide(this.minDe, this.minIndex);
        if (rightmostSide == 1) {
            this.orientedDe = this.minDe.getSym();
        }
    }

    private void findRightmostEdgeAtNode() {
        Node node = this.minDe.getNode();
        DirectedEdgeStar star = (DirectedEdgeStar)node.getEdges();
        this.minDe = star.getRightmostEdge();
        if (!this.minDe.isForward()) {
            this.minDe = this.minDe.getSym();
            this.minIndex = this.minDe.getEdge().getCoordinates().length - 1;
        }
    }

    private void findRightmostEdgeAtVertex() {
        Coordinate[] pts = this.minDe.getEdge().getCoordinates();
        Assert.isTrue(this.minIndex > 0 && this.minIndex < pts.length, "rightmost point expected to be interior vertex of edge");
        Coordinate pPrev = pts[this.minIndex - 1];
        Coordinate pNext = pts[this.minIndex + 1];
        int orientation = CGAlgorithms.computeOrientation(this.minCoord, pNext, pPrev);
        boolean usePrev = false;
        if (pPrev.y < this.minCoord.y && pNext.y < this.minCoord.y && orientation == 1) {
            usePrev = true;
        } else if (pPrev.y > this.minCoord.y && pNext.y > this.minCoord.y && orientation == -1) {
            usePrev = true;
        }
        if (usePrev) {
            --this.minIndex;
        }
    }

    private void checkForRightmostCoordinate(DirectedEdge de2) {
        Coordinate[] coord = de2.getEdge().getCoordinates();
        for (int i2 = 0; i2 < coord.length - 1; ++i2) {
            if (this.minCoord != null && !(coord[i2].x > this.minCoord.x)) continue;
            this.minDe = de2;
            this.minIndex = i2;
            this.minCoord = coord[i2];
        }
    }

    private int getRightmostSide(DirectedEdge de2, int index) {
        int side = this.getRightmostSideOfSegment(de2, index);
        if (side < 0) {
            side = this.getRightmostSideOfSegment(de2, index - 1);
        }
        if (side < 0) {
            this.minCoord = null;
            this.checkForRightmostCoordinate(de2);
        }
        return side;
    }

    private int getRightmostSideOfSegment(DirectedEdge de2, int i2) {
        Edge e2 = de2.getEdge();
        Coordinate[] coord = e2.getCoordinates();
        if (i2 < 0 || i2 + 1 >= coord.length) {
            return -1;
        }
        if (coord[i2].y == coord[i2 + 1].y) {
            return -1;
        }
        int pos = 1;
        if (coord[i2].y < coord[i2 + 1].y) {
            pos = 2;
        }
        return pos;
    }
}

