/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding.snapround;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.noding.IntersectionFinderAdder;
import com.vividsolutions.jts.noding.MCIndexNoder;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.Noder;
import com.vividsolutions.jts.noding.NodingValidator;
import com.vividsolutions.jts.noding.snapround.HotPixel;
import com.vividsolutions.jts.noding.snapround.MCIndexPointSnapper;
import java.util.Collection;
import java.util.List;

public class MCIndexSnapRounder
implements Noder {
    private final PrecisionModel pm;
    private LineIntersector li;
    private final double scaleFactor;
    private MCIndexNoder noder;
    private MCIndexPointSnapper pointSnapper;
    private Collection nodedSegStrings;

    public MCIndexSnapRounder(PrecisionModel pm2) {
        this.pm = pm2;
        this.li = new RobustLineIntersector();
        this.li.setPrecisionModel(pm2);
        this.scaleFactor = pm2.getScale();
    }

    public Collection getNodedSubstrings() {
        return NodedSegmentString.getNodedSubstrings(this.nodedSegStrings);
    }

    public void computeNodes(Collection inputSegmentStrings) {
        this.nodedSegStrings = inputSegmentStrings;
        this.noder = new MCIndexNoder();
        this.pointSnapper = new MCIndexPointSnapper(this.noder.getIndex());
        this.snapRound(inputSegmentStrings, this.li);
    }

    private void checkCorrectness(Collection inputSegmentStrings) {
        List resultSegStrings = NodedSegmentString.getNodedSubstrings(inputSegmentStrings);
        NodingValidator nv2 = new NodingValidator(resultSegStrings);
        try {
            nv2.checkValid();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    private void snapRound(Collection segStrings, LineIntersector li2) {
        List intersections = this.findInteriorIntersections(segStrings, li2);
        this.computeIntersectionSnaps(intersections);
        this.computeVertexSnaps(segStrings);
    }

    private List findInteriorIntersections(Collection segStrings, LineIntersector li2) {
        IntersectionFinderAdder intFinderAdder = new IntersectionFinderAdder(li2);
        this.noder.setSegmentIntersector(intFinderAdder);
        this.noder.computeNodes(segStrings);
        return intFinderAdder.getInteriorIntersections();
    }

    private void computeIntersectionSnaps(Collection snapPts) {
        for (Coordinate snapPt : snapPts) {
            HotPixel hotPixel = new HotPixel(snapPt, this.scaleFactor, this.li);
            this.pointSnapper.snap(hotPixel);
        }
    }

    public void computeVertexSnaps(Collection edges) {
        for (NodedSegmentString edge0 : edges) {
            this.computeVertexSnaps(edge0);
        }
    }

    private void computeVertexSnaps(NodedSegmentString e2) {
        Coordinate[] pts0 = e2.getCoordinates();
        for (int i2 = 0; i2 < pts0.length; ++i2) {
            HotPixel hotPixel = new HotPixel(pts0[i2], this.scaleFactor, this.li);
            boolean isNodeAdded = this.pointSnapper.snap(hotPixel, e2, i2);
            if (!isNodeAdded) continue;
            e2.addIntersection(pts0[i2], i2);
        }
    }
}

