/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding.snapround;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.chain.MonotoneChain;
import com.vividsolutions.jts.index.chain.MonotoneChainSelectAction;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.noding.snapround.HotPixel;

public class MCIndexPointSnapper {
    public static int nSnaps = 0;
    private STRtree index;

    public MCIndexPointSnapper(SpatialIndex index) {
        this.index = (STRtree)index;
    }

    public boolean snap(HotPixel hotPixel, SegmentString parentEdge, int hotPixelVertexIndex) {
        final Envelope pixelEnv = hotPixel.getSafeEnvelope();
        final HotPixelSnapAction hotPixelSnapAction = new HotPixelSnapAction(hotPixel, parentEdge, hotPixelVertexIndex);
        this.index.query(pixelEnv, new ItemVisitor(){

            public void visitItem(Object item) {
                MonotoneChain testChain = (MonotoneChain)item;
                testChain.select(pixelEnv, hotPixelSnapAction);
            }
        });
        return hotPixelSnapAction.isNodeAdded();
    }

    public boolean snap(HotPixel hotPixel) {
        return this.snap(hotPixel, null, -1);
    }

    public class HotPixelSnapAction
    extends MonotoneChainSelectAction {
        private HotPixel hotPixel;
        private SegmentString parentEdge;
        private int hotPixelVertexIndex;
        private boolean isNodeAdded = false;

        public HotPixelSnapAction(HotPixel hotPixel, SegmentString parentEdge, int hotPixelVertexIndex) {
            this.hotPixel = hotPixel;
            this.parentEdge = parentEdge;
            this.hotPixelVertexIndex = hotPixelVertexIndex;
        }

        public boolean isNodeAdded() {
            return this.isNodeAdded;
        }

        public void select(MonotoneChain mc2, int startIndex) {
            NodedSegmentString ss = (NodedSegmentString)mc2.getContext();
            if (this.parentEdge != null && ss == this.parentEdge && startIndex == this.hotPixelVertexIndex) {
                return;
            }
            this.isNodeAdded = this.hotPixel.addSnappedNode(ss, startIndex);
        }
    }
}

