/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding.snapround;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.util.Assert;

public class HotPixel {
    private LineIntersector li;
    private Coordinate pt;
    private Coordinate originalPt;
    private Coordinate ptScaled;
    private Coordinate p0Scaled;
    private Coordinate p1Scaled;
    private double scaleFactor;
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;
    private Coordinate[] corner = new Coordinate[4];
    private Envelope safeEnv = null;
    private static final double SAFE_ENV_EXPANSION_FACTOR = 0.75;

    public HotPixel(Coordinate pt2, double scaleFactor, LineIntersector li2) {
        this.originalPt = pt2;
        this.pt = pt2;
        this.scaleFactor = scaleFactor;
        this.li = li2;
        if (scaleFactor <= 0.0) {
            throw new IllegalArgumentException("Scale factor must be non-zero");
        }
        if (scaleFactor != 1.0) {
            this.pt = new Coordinate(this.scale(pt2.x), this.scale(pt2.y));
            this.p0Scaled = new Coordinate();
            this.p1Scaled = new Coordinate();
        }
        this.initCorners(this.pt);
    }

    public Coordinate getCoordinate() {
        return this.originalPt;
    }

    public Envelope getSafeEnvelope() {
        if (this.safeEnv == null) {
            double safeTolerance = 0.75 / this.scaleFactor;
            this.safeEnv = new Envelope(this.originalPt.x - safeTolerance, this.originalPt.x + safeTolerance, this.originalPt.y - safeTolerance, this.originalPt.y + safeTolerance);
        }
        return this.safeEnv;
    }

    private void initCorners(Coordinate pt2) {
        double tolerance = 0.5;
        this.minx = pt2.x - tolerance;
        this.maxx = pt2.x + tolerance;
        this.miny = pt2.y - tolerance;
        this.maxy = pt2.y + tolerance;
        this.corner[0] = new Coordinate(this.maxx, this.maxy);
        this.corner[1] = new Coordinate(this.minx, this.maxy);
        this.corner[2] = new Coordinate(this.minx, this.miny);
        this.corner[3] = new Coordinate(this.maxx, this.miny);
    }

    private double scale(double val) {
        return Math.round(val * this.scaleFactor);
    }

    public boolean intersects(Coordinate p0, Coordinate p1) {
        if (this.scaleFactor == 1.0) {
            return this.intersectsScaled(p0, p1);
        }
        this.copyScaled(p0, this.p0Scaled);
        this.copyScaled(p1, this.p1Scaled);
        return this.intersectsScaled(this.p0Scaled, this.p1Scaled);
    }

    private void copyScaled(Coordinate p2, Coordinate pScaled) {
        pScaled.x = this.scale(p2.x);
        pScaled.y = this.scale(p2.y);
    }

    private boolean intersectsScaled(Coordinate p0, Coordinate p1) {
        boolean isOutsidePixelEnv;
        double segMinx = Math.min(p0.x, p1.x);
        double segMaxx = Math.max(p0.x, p1.x);
        double segMiny = Math.min(p0.y, p1.y);
        double segMaxy = Math.max(p0.y, p1.y);
        boolean bl2 = isOutsidePixelEnv = this.maxx < segMinx || this.minx > segMaxx || this.maxy < segMiny || this.miny > segMaxy;
        if (isOutsidePixelEnv) {
            return false;
        }
        boolean intersects = this.intersectsToleranceSquare(p0, p1);
        Assert.isTrue(!isOutsidePixelEnv || !intersects, "Found bad envelope test");
        return intersects;
    }

    private boolean intersectsToleranceSquare(Coordinate p0, Coordinate p1) {
        boolean intersectsLeft = false;
        boolean intersectsBottom = false;
        this.li.computeIntersection(p0, p1, this.corner[0], this.corner[1]);
        if (this.li.isProper()) {
            return true;
        }
        this.li.computeIntersection(p0, p1, this.corner[1], this.corner[2]);
        if (this.li.isProper()) {
            return true;
        }
        if (this.li.hasIntersection()) {
            intersectsLeft = true;
        }
        this.li.computeIntersection(p0, p1, this.corner[2], this.corner[3]);
        if (this.li.isProper()) {
            return true;
        }
        if (this.li.hasIntersection()) {
            intersectsBottom = true;
        }
        this.li.computeIntersection(p0, p1, this.corner[3], this.corner[0]);
        if (this.li.isProper()) {
            return true;
        }
        if (intersectsLeft && intersectsBottom) {
            return true;
        }
        if (p0.equals(this.pt)) {
            return true;
        }
        return p1.equals(this.pt);
    }

    private boolean intersectsPixelClosure(Coordinate p0, Coordinate p1) {
        this.li.computeIntersection(p0, p1, this.corner[0], this.corner[1]);
        if (this.li.hasIntersection()) {
            return true;
        }
        this.li.computeIntersection(p0, p1, this.corner[1], this.corner[2]);
        if (this.li.hasIntersection()) {
            return true;
        }
        this.li.computeIntersection(p0, p1, this.corner[2], this.corner[3]);
        if (this.li.hasIntersection()) {
            return true;
        }
        this.li.computeIntersection(p0, p1, this.corner[3], this.corner[0]);
        return this.li.hasIntersection();
    }

    public boolean addSnappedNode(NodedSegmentString segStr, int segIndex) {
        Coordinate p1;
        Coordinate p0 = segStr.getCoordinate(segIndex);
        if (this.intersects(p0, p1 = segStr.getCoordinate(segIndex + 1))) {
            segStr.addIntersection(this.getCoordinate(), segIndex);
            return true;
        }
        return false;
    }
}

