/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.math;

public class MathUtil {
    private static final double LOG_10 = Math.log(10.0);

    public static double clamp(double x2, double min2, double max) {
        if (x2 < min2) {
            return min2;
        }
        if (x2 > max) {
            return max;
        }
        return x2;
    }

    public static int clamp(int x2, int min2, int max) {
        if (x2 < min2) {
            return min2;
        }
        if (x2 > max) {
            return max;
        }
        return x2;
    }

    public static double log10(double x2) {
        double ln2 = Math.log(x2);
        if (Double.isInfinite(ln2)) {
            return ln2;
        }
        if (Double.isNaN(ln2)) {
            return ln2;
        }
        return ln2 / LOG_10;
    }

    public static int wrap(int index, int max) {
        if (index < 0) {
            return max - -index % max;
        }
        return index % max;
    }

    public static double average(double x1, double x2) {
        return (x1 + x2) / 2.0;
    }

    public static double max(double v1, double v2, double v3) {
        double max = v1;
        if (v2 > max) {
            max = v2;
        }
        if (v3 > max) {
            max = v3;
        }
        return max;
    }

    public static double max(double v1, double v2, double v3, double v4) {
        double max = v1;
        if (v2 > max) {
            max = v2;
        }
        if (v3 > max) {
            max = v3;
        }
        if (v4 > max) {
            max = v4;
        }
        return max;
    }

    public static double min(double v1, double v2, double v3, double v4) {
        double min2 = v1;
        if (v2 < min2) {
            min2 = v2;
        }
        if (v3 < min2) {
            min2 = v3;
        }
        if (v4 < min2) {
            min2 = v4;
        }
        return min2;
    }
}

