/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.linearref.ExtractLineByLocation;
import com.vividsolutions.jts.linearref.LengthIndexOfPoint;
import com.vividsolutions.jts.linearref.LengthLocationMap;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.linearref.LocationIndexOfLine;
import com.vividsolutions.jts.linearref.LocationIndexedLine;

public class LengthIndexedLine {
    private Geometry linearGeom;

    public LengthIndexedLine(Geometry linearGeom) {
        this.linearGeom = linearGeom;
    }

    public Coordinate extractPoint(double index) {
        LinearLocation loc = LengthLocationMap.getLocation(this.linearGeom, index);
        return loc.getCoordinate(this.linearGeom);
    }

    public Coordinate extractPoint(double index, double offsetDistance) {
        LinearLocation loc = LengthLocationMap.getLocation(this.linearGeom, index);
        return loc.getSegment(this.linearGeom).pointAlongOffset(loc.getSegmentFraction(), offsetDistance);
    }

    public Geometry extractLine(double startIndex, double endIndex) {
        double endIndex2;
        LocationIndexedLine lil = new LocationIndexedLine(this.linearGeom);
        double startIndex2 = this.clampIndex(startIndex);
        boolean resolveStartLower = startIndex2 == (endIndex2 = this.clampIndex(endIndex));
        LinearLocation startLoc = this.locationOf(startIndex2, resolveStartLower);
        LinearLocation endLoc = this.locationOf(endIndex2);
        return ExtractLineByLocation.extract(this.linearGeom, startLoc, endLoc);
    }

    private LinearLocation locationOf(double index) {
        return LengthLocationMap.getLocation(this.linearGeom, index);
    }

    private LinearLocation locationOf(double index, boolean resolveLower) {
        return LengthLocationMap.getLocation(this.linearGeom, index, resolveLower);
    }

    public double indexOf(Coordinate pt2) {
        return LengthIndexOfPoint.indexOf(this.linearGeom, pt2);
    }

    public double indexOfAfter(Coordinate pt2, double minIndex) {
        return LengthIndexOfPoint.indexOfAfter(this.linearGeom, pt2, minIndex);
    }

    public double[] indicesOf(Geometry subLine) {
        LinearLocation[] locIndex = LocationIndexOfLine.indicesOf(this.linearGeom, subLine);
        double[] index = new double[]{LengthLocationMap.getLength(this.linearGeom, locIndex[0]), LengthLocationMap.getLength(this.linearGeom, locIndex[1])};
        return index;
    }

    public double project(Coordinate pt2) {
        return LengthIndexOfPoint.indexOf(this.linearGeom, pt2);
    }

    public double getStartIndex() {
        return 0.0;
    }

    public double getEndIndex() {
        return this.linearGeom.getLength();
    }

    public boolean isValidIndex(double index) {
        return index >= this.getStartIndex() && index <= this.getEndIndex();
    }

    public double clampIndex(double index) {
        double startIndex;
        double posIndex = this.positiveIndex(index);
        if (posIndex < (startIndex = this.getStartIndex())) {
            return startIndex;
        }
        double endIndex = this.getEndIndex();
        if (posIndex > endIndex) {
            return endIndex;
        }
        return posIndex;
    }

    private double positiveIndex(double index) {
        if (index >= 0.0) {
            return index;
        }
        return this.linearGeom.getLength() + index;
    }
}

