/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.EdgeEndStar;
import com.vividsolutions.jts.geomgraph.GraphComponent;
import com.vividsolutions.jts.geomgraph.Label;
import java.io.PrintStream;

public class Node
extends GraphComponent {
    protected Coordinate coord;
    protected EdgeEndStar edges;

    public Node(Coordinate coord, EdgeEndStar edges) {
        this.coord = coord;
        this.edges = edges;
        this.label = new Label(0, -1);
    }

    public Coordinate getCoordinate() {
        return this.coord;
    }

    public EdgeEndStar getEdges() {
        return this.edges;
    }

    public boolean isIncidentEdgeInResult() {
        for (DirectedEdge de2 : this.getEdges().getEdges()) {
            if (!de2.getEdge().isInResult()) continue;
            return true;
        }
        return false;
    }

    public boolean isIsolated() {
        return this.label.getGeometryCount() == 1;
    }

    protected void computeIM(IntersectionMatrix im2) {
    }

    public void add(EdgeEnd e2) {
        this.edges.insert(e2);
        e2.setNode(this);
    }

    public void mergeLabel(Node n2) {
        this.mergeLabel(n2.label);
    }

    public void mergeLabel(Label label2) {
        for (int i2 = 0; i2 < 2; ++i2) {
            int loc = this.computeMergedLocation(label2, i2);
            int thisLoc = this.label.getLocation(i2);
            if (thisLoc != -1) continue;
            this.label.setLocation(i2, loc);
        }
    }

    public void setLabel(int argIndex, int onLocation) {
        if (this.label == null) {
            this.label = new Label(argIndex, onLocation);
        } else {
            this.label.setLocation(argIndex, onLocation);
        }
    }

    public void setLabelBoundary(int argIndex) {
        int newLoc;
        if (this.label == null) {
            return;
        }
        int loc = -1;
        if (this.label != null) {
            loc = this.label.getLocation(argIndex);
        }
        switch (loc) {
            case 1: {
                newLoc = 0;
                break;
            }
            case 0: {
                newLoc = 1;
                break;
            }
            default: {
                newLoc = 1;
            }
        }
        this.label.setLocation(argIndex, newLoc);
    }

    int computeMergedLocation(Label label2, int eltIndex) {
        int loc = -1;
        loc = this.label.getLocation(eltIndex);
        if (!label2.isNull(eltIndex)) {
            int nLoc = label2.getLocation(eltIndex);
            if (loc != 1) {
                loc = nLoc;
            }
        }
        return loc;
    }

    public void print(PrintStream out) {
        out.println("node " + this.coord + " lbl: " + this.label);
    }
}

