/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public abstract class EdgeRing {
    protected DirectedEdge startDe;
    private int maxNodeDegree = -1;
    private List edges = new ArrayList();
    private List pts = new ArrayList();
    private Label label = new Label(-1);
    private LinearRing ring;
    private boolean isHole;
    private EdgeRing shell;
    private ArrayList holes = new ArrayList();
    protected GeometryFactory geometryFactory;

    public EdgeRing(DirectedEdge start, GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.computePoints(start);
        this.computeRing();
    }

    public boolean isIsolated() {
        return this.label.getGeometryCount() == 1;
    }

    public boolean isHole() {
        return this.isHole;
    }

    public Coordinate getCoordinate(int i2) {
        return (Coordinate)this.pts.get(i2);
    }

    public LinearRing getLinearRing() {
        return this.ring;
    }

    public Label getLabel() {
        return this.label;
    }

    public boolean isShell() {
        return this.shell == null;
    }

    public EdgeRing getShell() {
        return this.shell;
    }

    public void setShell(EdgeRing shell) {
        this.shell = shell;
        if (shell != null) {
            shell.addHole(this);
        }
    }

    public void addHole(EdgeRing ring) {
        this.holes.add(ring);
    }

    public Polygon toPolygon(GeometryFactory geometryFactory) {
        LinearRing[] holeLR = new LinearRing[this.holes.size()];
        for (int i2 = 0; i2 < this.holes.size(); ++i2) {
            holeLR[i2] = ((EdgeRing)this.holes.get(i2)).getLinearRing();
        }
        Polygon poly = geometryFactory.createPolygon(this.getLinearRing(), holeLR);
        return poly;
    }

    public void computeRing() {
        if (this.ring != null) {
            return;
        }
        Coordinate[] coord = new Coordinate[this.pts.size()];
        for (int i2 = 0; i2 < this.pts.size(); ++i2) {
            coord[i2] = (Coordinate)this.pts.get(i2);
        }
        this.ring = this.geometryFactory.createLinearRing(coord);
        this.isHole = CGAlgorithms.isCCW(this.ring.getCoordinates());
    }

    public abstract DirectedEdge getNext(DirectedEdge var1);

    public abstract void setEdgeRing(DirectedEdge var1, EdgeRing var2);

    public List getEdges() {
        return this.edges;
    }

    protected void computePoints(DirectedEdge start) {
        this.startDe = start;
        DirectedEdge de2 = start;
        boolean isFirstEdge = true;
        do {
            if (de2 == null) {
                throw new TopologyException("Found null DirectedEdge");
            }
            if (de2.getEdgeRing() == this) {
                throw new TopologyException("Directed Edge visited twice during ring-building at " + de2.getCoordinate());
            }
            this.edges.add(de2);
            Label label = de2.getLabel();
            Assert.isTrue(label.isArea());
            this.mergeLabel(label);
            this.addPoints(de2.getEdge(), de2.isForward(), isFirstEdge);
            isFirstEdge = false;
            this.setEdgeRing(de2, this);
        } while ((de2 = this.getNext(de2)) != this.startDe);
    }

    public int getMaxNodeDegree() {
        if (this.maxNodeDegree < 0) {
            this.computeMaxNodeDegree();
        }
        return this.maxNodeDegree;
    }

    private void computeMaxNodeDegree() {
        this.maxNodeDegree = 0;
        DirectedEdge de2 = this.startDe;
        do {
            Node node;
            int degree;
            if ((degree = ((DirectedEdgeStar)(node = de2.getNode()).getEdges()).getOutgoingDegree(this)) <= this.maxNodeDegree) continue;
            this.maxNodeDegree = degree;
        } while ((de2 = this.getNext(de2)) != this.startDe);
        this.maxNodeDegree *= 2;
    }

    public void setInResult() {
        DirectedEdge de2 = this.startDe;
        do {
            de2.getEdge().setInResult(true);
        } while ((de2 = de2.getNext()) != this.startDe);
    }

    protected void mergeLabel(Label deLabel) {
        this.mergeLabel(deLabel, 0);
        this.mergeLabel(deLabel, 1);
    }

    protected void mergeLabel(Label deLabel, int geomIndex) {
        int loc = deLabel.getLocation(geomIndex, 2);
        if (loc == -1) {
            return;
        }
        if (this.label.getLocation(geomIndex) == -1) {
            this.label.setLocation(geomIndex, loc);
            return;
        }
    }

    protected void addPoints(Edge edge, boolean isForward, boolean isFirstEdge) {
        Coordinate[] edgePts = edge.getCoordinates();
        if (isForward) {
            int startIndex = 1;
            if (isFirstEdge) {
                startIndex = 0;
            }
            for (int i2 = startIndex; i2 < edgePts.length; ++i2) {
                this.pts.add(edgePts[i2]);
            }
        } else {
            int startIndex = edgePts.length - 2;
            if (isFirstEdge) {
                startIndex = edgePts.length - 1;
            }
            for (int i3 = startIndex; i3 >= 0; --i3) {
                this.pts.add(edgePts[i3]);
            }
        }
    }

    public boolean containsPoint(Coordinate p2) {
        LinearRing shell = this.getLinearRing();
        Envelope env = shell.getEnvelopeInternal();
        if (!env.contains(p2)) {
            return false;
        }
        if (!CGAlgorithms.isPointInRing(p2, shell.getCoordinates())) {
            return false;
        }
        for (EdgeRing hole : this.holes) {
            if (!hole.containsPoint(p2)) continue;
            return false;
        }
        return true;
    }
}

