/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.Label;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EdgeIntersectionList {
    private Map nodeMap = new TreeMap();
    Edge edge;

    public EdgeIntersectionList(Edge edge) {
        this.edge = edge;
    }

    public EdgeIntersection add(Coordinate intPt, int segmentIndex, double dist) {
        EdgeIntersection eiNew = new EdgeIntersection(intPt, segmentIndex, dist);
        EdgeIntersection ei2 = (EdgeIntersection)this.nodeMap.get(eiNew);
        if (ei2 != null) {
            return ei2;
        }
        this.nodeMap.put(eiNew, eiNew);
        return eiNew;
    }

    public Iterator iterator() {
        return this.nodeMap.values().iterator();
    }

    public boolean isIntersection(Coordinate pt2) {
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            EdgeIntersection ei2 = (EdgeIntersection)it2.next();
            if (!ei2.coord.equals(pt2)) continue;
            return true;
        }
        return false;
    }

    public void addEndpoints() {
        int maxSegIndex = this.edge.pts.length - 1;
        this.add(this.edge.pts[0], 0, 0.0);
        this.add(this.edge.pts[maxSegIndex], maxSegIndex, 0.0);
    }

    public void addSplitEdges(List edgeList) {
        this.addEndpoints();
        Iterator it2 = this.iterator();
        EdgeIntersection eiPrev = (EdgeIntersection)it2.next();
        while (it2.hasNext()) {
            EdgeIntersection ei2 = (EdgeIntersection)it2.next();
            Edge newEdge = this.createSplitEdge(eiPrev, ei2);
            edgeList.add(newEdge);
            eiPrev = ei2;
        }
    }

    Edge createSplitEdge(EdgeIntersection ei0, EdgeIntersection ei1) {
        boolean useIntPt1;
        int npts = ei1.segmentIndex - ei0.segmentIndex + 2;
        Coordinate lastSegStartPt = this.edge.pts[ei1.segmentIndex];
        boolean bl2 = useIntPt1 = ei1.dist > 0.0 || !ei1.coord.equals2D(lastSegStartPt);
        if (!useIntPt1) {
            --npts;
        }
        Coordinate[] pts = new Coordinate[npts];
        int ipt = 0;
        pts[ipt++] = new Coordinate(ei0.coord);
        for (int i2 = ei0.segmentIndex + 1; i2 <= ei1.segmentIndex; ++i2) {
            pts[ipt++] = this.edge.pts[i2];
        }
        if (useIntPt1) {
            pts[ipt] = ei1.coord;
        }
        return new Edge(pts, new Label(this.edge.label));
    }

    public void print(PrintStream out) {
        out.println("Intersections:");
        Iterator it2 = this.iterator();
        while (it2.hasNext()) {
            EdgeIntersection ei2 = (EdgeIntersection)it2.next();
            ei2.print(out);
        }
    }
}

