/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.geom.util.AffineTransformationBuilder;

public class AffineTransformationFactory {
    public static AffineTransformation createFromControlVectors(Coordinate src0, Coordinate src1, Coordinate src2, Coordinate dest0, Coordinate dest1, Coordinate dest2) {
        AffineTransformationBuilder builder = new AffineTransformationBuilder(src0, src1, src2, dest0, dest1, dest2);
        return builder.getTransformation();
    }

    public static AffineTransformation createFromControlVectors(Coordinate src0, Coordinate src1, Coordinate dest0, Coordinate dest1) {
        Coordinate rotPt = new Coordinate(dest1.x - dest0.x, dest1.y - dest0.y);
        double ang = Angle.angleBetweenOriented(src1, src0, rotPt);
        double srcDist = src1.distance(src0);
        double destDist = dest1.distance(dest0);
        if (srcDist == 0.0) {
            return null;
        }
        double scale = destDist / srcDist;
        AffineTransformation trans = AffineTransformation.translationInstance(-src0.x, -src0.y);
        trans.rotate(ang);
        trans.scale(scale, scale);
        trans.translate(dest0.x, dest0.y);
        return trans;
    }

    public static AffineTransformation createFromControlVectors(Coordinate src0, Coordinate dest0) {
        double dx2 = dest0.x - src0.x;
        double dy2 = dest0.y - src0.y;
        return AffineTransformation.translationInstance(dx2, dy2);
    }

    public static AffineTransformation createFromControlVectors(Coordinate[] src, Coordinate[] dest) {
        if (src.length != dest.length) {
            throw new IllegalArgumentException("Src and Dest arrays are not the same length");
        }
        if (src.length <= 0) {
            throw new IllegalArgumentException("Too few control points");
        }
        if (src.length > 3) {
            throw new IllegalArgumentException("Too many control points");
        }
        if (src.length == 1) {
            return AffineTransformationFactory.createFromControlVectors(src[0], dest[0]);
        }
        if (src.length == 2) {
            return AffineTransformationFactory.createFromControlVectors(src[0], src[1], dest[0], dest[1]);
        }
        return AffineTransformationFactory.createFromControlVectors(src[0], src[1], src[2], dest[0], dest[1], dest[2]);
    }

    public static AffineTransformation createFromBaseLines(Coordinate src0, Coordinate src1, Coordinate dest0, Coordinate dest1) {
        Coordinate rotPt = new Coordinate(src0.x + dest1.x - dest0.x, src0.y + dest1.y - dest0.y);
        double ang = Angle.angleBetweenOriented(src1, src0, rotPt);
        double srcDist = src1.distance(src0);
        double destDist = dest1.distance(dest0);
        if (srcDist == 0.0) {
            return new AffineTransformation();
        }
        double scale = destDist / srcDist;
        AffineTransformation trans = AffineTransformation.translationInstance(-src0.x, -src0.y);
        trans.rotate(ang);
        trans.scale(scale, scale);
        trans.translate(dest0.x, dest0.y);
        return trans;
    }
}

