/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;

public class CentroidLine {
    private Coordinate centSum = new Coordinate();
    private double totalLength = 0.0;

    public void add(Geometry geom) {
        block3: {
            block4: {
                block2: {
                    if (!(geom instanceof LineString)) break block2;
                    this.add(geom.getCoordinates());
                    break block3;
                }
                if (!(geom instanceof Polygon)) break block4;
                Polygon poly = (Polygon)geom;
                this.add(poly.getExteriorRing().getCoordinates());
                for (int i2 = 0; i2 < poly.getNumInteriorRing(); ++i2) {
                    this.add(poly.getInteriorRingN(i2).getCoordinates());
                }
                break block3;
            }
            if (!(geom instanceof GeometryCollection)) break block3;
            GeometryCollection gc2 = (GeometryCollection)geom;
            for (int i3 = 0; i3 < gc2.getNumGeometries(); ++i3) {
                this.add(gc2.getGeometryN(i3));
            }
        }
    }

    public Coordinate getCentroid() {
        Coordinate cent = new Coordinate();
        cent.x = this.centSum.x / this.totalLength;
        cent.y = this.centSum.y / this.totalLength;
        return cent;
    }

    public void add(Coordinate[] pts) {
        for (int i2 = 0; i2 < pts.length - 1; ++i2) {
            double segmentLen = pts[i2].distance(pts[i2 + 1]);
            this.totalLength += segmentLen;
            double midx = (pts[i2].x + pts[i2 + 1].x) / 2.0;
            this.centSum.x += segmentLen * midx;
            double midy = (pts[i2].y + pts[i2 + 1].y) / 2.0;
            this.centSum.y += segmentLen * midy;
        }
    }
}

