/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.math.Vector3D;

public class CGAlgorithms3D {
    public static double distance(Coordinate p0, Coordinate p1) {
        if (Double.isNaN(p0.z) || Double.isNaN(p1.z)) {
            return p0.distance(p1);
        }
        double dx2 = p0.x - p1.x;
        double dy2 = p0.y - p1.y;
        double dz2 = p0.z - p1.z;
        return Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2);
    }

    public static double distancePointSegment(Coordinate p2, Coordinate A2, Coordinate B2) {
        if (A2.equals3D(B2)) {
            return CGAlgorithms3D.distance(p2, A2);
        }
        double len2 = (B2.x - A2.x) * (B2.x - A2.x) + (B2.y - A2.y) * (B2.y - A2.y) + (B2.z - A2.z) * (B2.z - A2.z);
        if (Double.isNaN(len2)) {
            throw new IllegalArgumentException("Ordinates must not be NaN");
        }
        double r2 = ((p2.x - A2.x) * (B2.x - A2.x) + (p2.y - A2.y) * (B2.y - A2.y) + (p2.z - A2.z) * (B2.z - A2.z)) / len2;
        if (r2 <= 0.0) {
            return CGAlgorithms3D.distance(p2, A2);
        }
        if (r2 >= 1.0) {
            return CGAlgorithms3D.distance(p2, B2);
        }
        double qx = A2.x + r2 * (B2.x - A2.x);
        double qy = A2.y + r2 * (B2.y - A2.y);
        double qz = A2.z + r2 * (B2.z - A2.z);
        double dx2 = p2.x - qx;
        double dy2 = p2.y - qy;
        double dz2 = p2.z - qz;
        return Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2);
    }

    public static double distanceSegmentSegment(Coordinate A2, Coordinate B2, Coordinate C2, Coordinate D2) {
        double t2;
        double s2;
        if (A2.equals3D(B2)) {
            return CGAlgorithms3D.distancePointSegment(A2, C2, D2);
        }
        if (C2.equals3D(B2)) {
            return CGAlgorithms3D.distancePointSegment(C2, A2, B2);
        }
        double a2 = Vector3D.dot(A2, B2, A2, B2);
        double b2 = Vector3D.dot(A2, B2, C2, D2);
        double c2 = Vector3D.dot(C2, D2, C2, D2);
        double d2 = Vector3D.dot(A2, B2, C2, A2);
        double e2 = Vector3D.dot(C2, D2, C2, A2);
        double denom = a2 * c2 - b2 * b2;
        if (Double.isNaN(denom)) {
            throw new IllegalArgumentException("Ordinates must not be NaN");
        }
        if (denom <= 0.0) {
            s2 = 0.0;
            t2 = b2 > c2 ? d2 / b2 : e2 / c2;
        } else {
            s2 = (b2 * e2 - c2 * d2) / denom;
            t2 = (a2 * e2 - b2 * d2) / denom;
        }
        if (s2 < 0.0) {
            return CGAlgorithms3D.distancePointSegment(A2, C2, D2);
        }
        if (s2 > 1.0) {
            return CGAlgorithms3D.distancePointSegment(B2, C2, D2);
        }
        if (t2 < 0.0) {
            return CGAlgorithms3D.distancePointSegment(C2, A2, B2);
        }
        if (t2 > 1.0) {
            return CGAlgorithms3D.distancePointSegment(D2, A2, B2);
        }
        double x1 = A2.x + s2 * (B2.x - A2.x);
        double y1 = A2.y + s2 * (B2.y - A2.y);
        double z1 = A2.z + s2 * (B2.z - A2.z);
        double x2 = C2.x + t2 * (D2.x - C2.x);
        double y2 = C2.y + t2 * (D2.y - C2.y);
        double z2 = C2.z + t2 * (D2.z - C2.z);
        return CGAlgorithms3D.distance(new Coordinate(x1, y1, z1), new Coordinate(x2, y2, z2));
    }
}

