/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Pixels;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.QueuedPixelSource;
import java.nio.IntBuffer;

final class UploadingPainter
extends ViewPainter
implements Runnable {
    private RTTexture rttexture;
    private RTTexture resolveRTT = null;
    private QueuedPixelSource pixelSource = new QueuedPixelSource(true);
    private float penScaleX;
    private float penScaleY;

    UploadingPainter(GlassScene glassScene) {
        super(glassScene);
    }

    void disposeRTTexture() {
        if (this.rttexture != null) {
            this.rttexture.dispose();
            this.rttexture = null;
        }
        if (this.resolveRTT != null) {
            this.resolveRTT.dispose();
            this.resolveRTT = null;
        }
    }

    @Override
    public float getPixelScaleFactorX() {
        return this.sceneState.getRenderScaleX();
    }

    @Override
    public float getPixelScaleFactorY() {
        return this.sceneState.getRenderScaleY();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        renderLock.lock();
        boolean bl2 = false;
        try {
            Graphics graphics;
            boolean bl3;
            if (!this.validateStageGraphics()) {
                if (QuantumToolkit.verbose) {
                    System.err.println("UploadingPainter: validateStageGraphics failed");
                }
                this.paintImpl(null);
                return;
            }
            if (this.factory == null) {
                this.factory = GraphicsPipeline.getDefaultResourceFactory();
            }
            if (this.factory == null || !this.factory.isDeviceReady()) {
                this.factory = null;
                return;
            }
            float f2 = this.getPixelScaleFactorX();
            float f3 = this.getPixelScaleFactorY();
            int n2 = this.sceneState.getRenderWidth();
            int n3 = this.sceneState.getRenderHeight();
            boolean bl4 = bl3 = this.penScaleX != f2 || this.penScaleY != f3 || this.penWidth != this.viewWidth || this.penHeight != this.viewHeight || this.rttexture == null || this.rttexture.getContentWidth() != n2 || this.rttexture.getContentHeight() != n3;
            if (!bl3) {
                this.rttexture.lock();
                if (this.rttexture.isSurfaceLost()) {
                    this.rttexture.unlock();
                    this.sceneState.getScene().entireSceneNeedsRepaint();
                    bl3 = true;
                }
            }
            if (bl3) {
                this.disposeRTTexture();
                this.rttexture = this.factory.createRTTexture(n2, n3, Texture.WrapMode.CLAMP_NOT_NEEDED, this.sceneState.isMSAA());
                if (this.rttexture == null) {
                    return;
                }
                this.penScaleX = f2;
                this.penScaleY = f3;
                this.penWidth = this.viewWidth;
                this.penHeight = this.viewHeight;
                this.freshBackBuffer = true;
            }
            if ((graphics = this.rttexture.createGraphics()) == null) {
                this.disposeRTTexture();
                this.sceneState.getScene().entireSceneNeedsRepaint();
                return;
            }
            graphics.scale(f2, f3);
            this.paintImpl(graphics);
            this.freshBackBuffer = false;
            int n4 = this.sceneState.getOutputWidth();
            int n5 = this.sceneState.getOutputHeight();
            float f4 = this.sceneState.getOutputScaleX();
            float f5 = this.sceneState.getOutputScaleY();
            RTTexture rTTexture = this.rttexture.isMSAA() || n4 != n2 || n5 != n3 ? this.resolveRenderTarget(graphics, n4, n5) : this.rttexture;
            Pixels pixels = this.pixelSource.getUnusedPixels(n4, n5, f4, f5);
            IntBuffer intBuffer = (IntBuffer)pixels.getPixels();
            int[] nArray = rTTexture.getPixels();
            if (nArray != null) {
                intBuffer.put(nArray, 0, n4 * n5);
            } else if (!rTTexture.readPixels(intBuffer)) {
                this.sceneState.getScene().entireSceneNeedsRepaint();
                this.disposeRTTexture();
                pixels = null;
            }
            if (this.rttexture != null) {
                this.rttexture.unlock();
            }
            if (pixels != null) {
                this.pixelSource.enqueuePixels(pixels);
                this.sceneState.uploadPixels(this.pixelSource);
            }
        }
        catch (Throwable throwable) {
            bl2 = true;
            throwable.printStackTrace(System.err);
        }
        finally {
            if (this.rttexture != null && this.rttexture.isLocked()) {
                this.rttexture.unlock();
            }
            if (this.resolveRTT != null && this.resolveRTT.isLocked()) {
                this.resolveRTT.unlock();
            }
            Disposer.cleanUp();
            this.sceneState.getScene().setPainting(false);
            if (this.factory != null) {
                this.factory.getTextureResourcePool().freeDisposalRequestedAndCheckResources(bl2);
            }
            renderLock.unlock();
        }
    }

    private RTTexture resolveRenderTarget(Graphics graphics, int n2, int n3) {
        if (this.resolveRTT != null) {
            this.resolveRTT.lock();
            if (this.resolveRTT.isSurfaceLost() || this.resolveRTT.getContentWidth() != n2 || this.resolveRTT.getContentHeight() != n3) {
                this.resolveRTT.unlock();
                this.resolveRTT.dispose();
                this.resolveRTT = null;
            }
        }
        if (this.resolveRTT == null) {
            this.resolveRTT = graphics.getResourceFactory().createRTTexture(n2, n3, Texture.WrapMode.CLAMP_NOT_NEEDED, false);
        }
        int n4 = this.rttexture.getContentWidth();
        int n5 = this.rttexture.getContentHeight();
        graphics.blit(this.rttexture, this.resolveRTT, 0, 0, n4, n5, 0, 0, n2, n3);
        return this.resolveRTT;
    }
}

