/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import javafx.css.ParsedValue;
import javafx.css.Size;
import javafx.css.SizeUnits;
import javafx.css.StyleConverter;
import javafx.css.converter.BooleanConverter;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.text.Font;

public final class BackgroundSizeConverter
extends StyleConverter<ParsedValue[], BackgroundSize> {
    private static final BackgroundSizeConverter BACKGROUND_SIZE_CONVERTER = new BackgroundSizeConverter();

    public static BackgroundSizeConverter getInstance() {
        return BACKGROUND_SIZE_CONVERTER;
    }

    private BackgroundSizeConverter() {
    }

    @Override
    public BackgroundSize convert(ParsedValue<ParsedValue[], BackgroundSize> parsedValue, Font font) {
        ParsedValue[] parsedValueArray = parsedValue.getValue();
        Size size = parsedValueArray[0] != null ? (Size)parsedValueArray[0].convert(font) : null;
        Size size2 = parsedValueArray[1] != null ? (Size)parsedValueArray[1].convert(font) : null;
        boolean bl2 = true;
        boolean bl3 = true;
        if (size != null) {
            boolean bl4 = bl2 = size.getUnits() == SizeUnits.PERCENT;
        }
        if (size2 != null) {
            bl3 = size2.getUnits() == SizeUnits.PERCENT;
        }
        double d2 = size != null ? size.pixels(font) : -1.0;
        double d3 = size2 != null ? size2.pixels(font) : -1.0;
        boolean bl5 = parsedValueArray[2] != null ? BooleanConverter.getInstance().convert(parsedValueArray[2], font) : false;
        boolean bl6 = parsedValueArray[3] != null ? BooleanConverter.getInstance().convert(parsedValueArray[3], font) : false;
        return new BackgroundSize(d2, d3, bl2, bl3, bl6, bl5);
    }

    public String toString() {
        return "BackgroundSizeConverter";
    }
}

