/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import java.util.Objects;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;

public class MnemonicInfo {
    private final char MNEMONIC_SYMBOL = (char)95;
    private String sourceText = null;
    private String text = null;
    private String mnemonic = null;
    private KeyCombination mnemonicKeyCombination = null;
    private int mnemonicIndex = -1;
    private String extendedMnemonicText = null;

    public String getText() {
        return this.text;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public KeyCombination getMnemonicKeyCombination() {
        if (this.mnemonic != null && this.mnemonicKeyCombination == null) {
            this.mnemonicKeyCombination = new MnemonicKeyCombination(this.mnemonic);
        }
        return this.mnemonicKeyCombination;
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public String getExtendedMnemonicText() {
        return this.extendedMnemonicText;
    }

    public MnemonicInfo(String string) {
        this.update(string);
    }

    public void update(String string) {
        if (!Objects.equals(this.sourceText, string)) {
            this.sourceText = string;
            this.mnemonic = null;
            this.mnemonicKeyCombination = null;
            this.mnemonicIndex = -1;
            this.extendedMnemonicText = null;
            this.parseAndSplit(string);
        }
    }

    private void parseAndSplit(String string) {
        int n2;
        if (string == null || string.length() == 0) {
            this.text = string;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n3 = string.length();
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.isEscapedMnemonicSymbol(string, n2)) {
                stringBuilder.append(string.charAt(n2++));
                continue;
            }
            if (this.isExtendedMnemonic(string, n2)) {
                this.mnemonic = String.valueOf(string.charAt(n2 + 2));
                this.mnemonicIndex = n2;
                this.extendedMnemonicText = string.substring(n2 + 1, n2 + 4);
                n2 += 4;
                break;
            }
            if (this.isSimpleMnemonic(string, n2)) {
                char c2 = string.charAt(n2 + 1);
                this.mnemonic = String.valueOf(c2);
                this.mnemonicIndex = n2++;
                break;
            }
            stringBuilder.append(string.charAt(n2));
        }
        if (string.length() > n2) {
            stringBuilder.append(string.substring(n2));
        }
        this.text = stringBuilder.toString();
    }

    private boolean isEscapedMnemonicSymbol(String string, int n2) {
        return string.length() > n2 + 1 && string.charAt(n2) == '_' && string.charAt(n2 + 1) == '_';
    }

    private boolean isSimpleMnemonic(String string, int n2) {
        return string.length() > n2 + 1 && string.charAt(n2) == '_' && string.charAt(n2 + 1) != '_' && !Character.isWhitespace(string.charAt(n2 + 1));
    }

    private boolean isExtendedMnemonic(String string, int n2) {
        return string.length() > n2 + 3 && string.charAt(n2) == '_' && string.charAt(n2 + 1) == '(' && !Character.isWhitespace(string.charAt(n2 + 2)) && string.charAt(n2 + 3) == ')';
    }

    public static class MnemonicKeyCombination
    extends KeyCombination {
        private String character = "";

        public MnemonicKeyCombination(String string) {
            super(PlatformUtil.isMac() ? KeyCombination.META_DOWN : KeyCombination.ALT_DOWN);
            this.character = string;
        }

        public final String getCharacter() {
            return this.character;
        }

        @Override
        public boolean match(KeyEvent keyEvent) {
            String string = keyEvent.getText();
            return string != null && !string.isEmpty() && string.equalsIgnoreCase(this.getCharacter()) && super.match(keyEvent);
        }

        @Override
        public String getName() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(super.getName());
            if (stringBuilder.length() > 0) {
                stringBuilder.append("+");
            }
            return stringBuilder.append('\'').append(this.character.replace("'", "\\'")).append('\'').toString();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof MnemonicKeyCombination)) {
                return false;
            }
            return this.character.equals(((MnemonicKeyCombination)object).getCharacter()) && super.equals(object);
        }

        @Override
        public int hashCode() {
            return 23 * super.hashCode() + this.character.hashCode();
        }
    }
}

