/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchMessages;
import com.github.fge.jsonpatch.JsonPatchOperation;
import com.github.fge.jsonpatch.Patch;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class JsonPatch
implements JsonSerializable,
Patch {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    private final List<JsonPatchOperation> operations;

    @JsonCreator
    public JsonPatch(List<JsonPatchOperation> operations) {
        this.operations = Collections.unmodifiableList(new ArrayList<JsonPatchOperation>(operations));
    }

    public static JsonPatch fromJson(JsonNode node) throws IOException {
        BUNDLE.checkNotNull(node, "jsonPatch.nullInput");
        return (JsonPatch)JacksonUtils.getReader().forType(JsonPatch.class).readValue(node);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        BUNDLE.checkNotNull(node, "jsonPatch.nullInput");
        JsonNode ret = node;
        for (JsonPatchOperation operation : this.operations) {
            ret = operation.apply(ret);
        }
        return ret;
    }

    public String toString() {
        return this.operations.toString();
    }

    @Override
    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartArray();
        for (JsonPatchOperation op2 : this.operations) {
            op2.serialize(jgen, provider);
        }
        jgen.writeEndArray();
    }

    @Override
    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(jgen, provider);
    }
}

