/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jackson;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.fge.Builder;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.bundle.PropertiesBundle;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class JsonNodeReader {
    private static final MessageBundle BUNDLE = PropertiesBundle.forPath("/com/github/fge/jackson/jsonNodeReader");
    private final ObjectReader reader;

    public JsonNodeReader(ObjectMapper mapper) {
        this.reader = mapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true).readerFor(JsonNode.class);
    }

    public JsonNodeReader() {
        this(JacksonUtils.newMapper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode fromInputStream(InputStream in2) throws IOException {
        JsonParser parser = null;
        MappingIterator<JsonNode> iterator = null;
        try {
            parser = this.reader.getFactory().createParser(in2);
            iterator = this.reader.readValues(parser);
            JsonNode jsonNode = JsonNodeReader.readNode(iterator);
            return jsonNode;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode fromReader(Reader r2) throws IOException {
        JsonParser parser = null;
        MappingIterator<JsonNode> iterator = null;
        try {
            parser = this.reader.getFactory().createParser(r2);
            iterator = this.reader.readValues(parser);
            JsonNode jsonNode = JsonNodeReader.readNode(iterator);
            return jsonNode;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    private static JsonNode readNode(MappingIterator<JsonNode> iterator) throws IOException {
        JsonParser parser = iterator.getParser();
        JsonParseExceptionBuilder builder = new JsonParseExceptionBuilder(parser);
        builder.setMessage(JsonNodeReader.BUNDLE.getMessage("read.noContent"));
        if (!iterator.hasNextValue()) {
            throw builder.build();
        }
        JsonNode ret = iterator.nextValue();
        builder.setMessage(JsonNodeReader.BUNDLE.getMessage("read.trailingData")).setLocation(iterator.getCurrentLocation());
        try {
            if (iterator.hasNextValue()) {
                throw builder.build();
            }
        }
        catch (JsonParseException e2) {
            throw builder.setLocation(e2.getLocation()).build();
        }
        return ret;
    }

    private static final class JsonParseExceptionBuilder
    implements Builder<JsonParseException> {
        private JsonParser parser;
        private String message = "";
        private JsonLocation location;

        private JsonParseExceptionBuilder(@Nonnull JsonParser parser) {
            BUNDLE.checkNotNull(parser, "read.nullArgument");
            this.parser = parser;
            this.location = parser.getCurrentLocation();
        }

        private JsonParseExceptionBuilder setMessage(@Nonnull String message) {
            this.message = BUNDLE.checkNotNull(message, "read.nullArgument");
            return this;
        }

        private JsonParseExceptionBuilder setLocation(@Nonnull JsonLocation location) {
            this.location = BUNDLE.checkNotNull(location, "read.nullArgument");
            return this;
        }

        @Override
        public JsonParseException build() {
            return new JsonParseException(this.parser, this.message, this.location);
        }
    }
}

