/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.CompositeConverter;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.SimpleKeywordNode;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Map;

class Compiler<E>
extends ContextAwareBase {
    Converter<E> head;
    Converter<E> tail;
    final Node top;
    final Map<String, String> converterMap;

    Compiler(Node top, Map<String, String> converterMap) {
        this.top = top;
        this.converterMap = converterMap;
    }

    Converter<E> compile() {
        this.tail = null;
        this.head = null;
        Node n2 = this.top;
        while (n2 != null) {
            switch (n2.type) {
                case 0: {
                    this.addToList(new LiteralConverter((String)n2.getValue()));
                    break;
                }
                case 2: {
                    CompositeNode cn2 = (CompositeNode)n2;
                    CompositeConverter<E> compositeConverter = this.createCompositeConverter(cn2);
                    if (compositeConverter == null) {
                        this.addError("Failed to create converter for [%" + String.valueOf(cn2.getValue()) + "] keyword");
                        this.addToList(new LiteralConverter("%PARSER_ERROR[" + String.valueOf(cn2.getValue()) + "]"));
                        break;
                    }
                    compositeConverter.setFormattingInfo(cn2.getFormatInfo());
                    compositeConverter.setOptionList(cn2.getOptions());
                    Compiler<E> childCompiler = new Compiler<E>(cn2.getChildNode(), this.converterMap);
                    childCompiler.setContext(this.context);
                    Converter<E> childConverter = childCompiler.compile();
                    compositeConverter.setChildConverter(childConverter);
                    this.addToList(compositeConverter);
                    break;
                }
                case 1: {
                    SimpleKeywordNode kn2 = (SimpleKeywordNode)n2;
                    DynamicConverter<E> dynaConverter = this.createConverter(kn2);
                    if (dynaConverter != null) {
                        dynaConverter.setFormattingInfo(kn2.getFormatInfo());
                        dynaConverter.setOptionList(kn2.getOptions());
                        this.addToList(dynaConverter);
                        break;
                    }
                    LiteralConverter errConveter = new LiteralConverter("%PARSER_ERROR[" + String.valueOf(kn2.getValue()) + "]");
                    this.addStatus(new ErrorStatus("[" + String.valueOf(kn2.getValue()) + "] is not a valid conversion word", this));
                    this.addToList(errConveter);
                }
            }
            n2 = n2.next;
        }
        return this.head;
    }

    private void addToList(Converter<E> c2) {
        if (this.head == null) {
            this.tail = c2;
            this.head = this.tail;
        } else {
            this.tail.setNext(c2);
            this.tail = c2;
        }
    }

    DynamicConverter<E> createConverter(SimpleKeywordNode kn2) {
        String keyword = (String)kn2.getValue();
        String converterClassStr = this.converterMap.get(keyword);
        if (converterClassStr != null) {
            try {
                return (DynamicConverter)OptionHelper.instantiateByClassName(converterClassStr, DynamicConverter.class, this.context);
            }
            catch (Exception e2) {
                this.addError("Failed to instantiate converter class [" + converterClassStr + "] for keyword [" + keyword + "]", e2);
                return null;
            }
        }
        this.addError("There is no conversion class registered for conversion word [" + keyword + "]");
        return null;
    }

    CompositeConverter<E> createCompositeConverter(CompositeNode cn2) {
        String keyword = (String)cn2.getValue();
        String converterClassStr = this.converterMap.get(keyword);
        if (converterClassStr != null) {
            try {
                return (CompositeConverter)OptionHelper.instantiateByClassName(converterClassStr, CompositeConverter.class, this.context);
            }
            catch (Exception e2) {
                this.addError("Failed to instantiate converter class [" + converterClassStr + "] as a composite converter for keyword [" + keyword + "]", e2);
                return null;
            }
        }
        this.addError("There is no conversion class registered for composite conversion word [" + keyword + "]");
        return null;
    }
}

