/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.binary;

public abstract class ByteGetter {
    public abstract int get(int var1);

    public static class StringByteGetter
    extends ByteGetter {
        private String rep;

        public StringByteGetter(String rep) {
            this.rep = rep;
        }

        @Override
        public int get(int index) {
            byte high = StringByteGetter.unhex(this.rep.charAt(index *= 2));
            byte low = StringByteGetter.unhex(this.rep.charAt(index + 1));
            return (high << 4) + low;
        }

        public static byte unhex(char c2) {
            if (c2 >= '0' && c2 <= '9') {
                return (byte)(c2 - 48);
            }
            if (c2 >= 'A' && c2 <= 'F') {
                return (byte)(c2 - 65 + 10);
            }
            if (c2 >= 'a' && c2 <= 'f') {
                return (byte)(c2 - 97 + 10);
            }
            throw new IllegalArgumentException("No valid Hex char " + c2);
        }
    }

    public static class BinaryByteGetter
    extends ByteGetter {
        private byte[] array;

        public BinaryByteGetter(byte[] array) {
            this.array = array;
        }

        @Override
        public int get(int index) {
            return this.array[index] & 0xFF;
        }
    }
}

