/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.ComposedGeom;
import org.postgis.Geometry;
import org.postgis.LineString;

public class MultiLineString
extends ComposedGeom {
    private static final long serialVersionUID = 256L;
    double len = -1.0;

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)this.length();
    }

    public MultiLineString() {
        super(5);
    }

    public MultiLineString(LineString[] lines) {
        super(5, lines);
    }

    public MultiLineString(String value) throws SQLException {
        this(value, false);
    }

    public MultiLineString(String value, boolean haveM) throws SQLException {
        super(5, value, haveM);
    }

    @Override
    protected Geometry createSubGeomInstance(String token, boolean haveM) throws SQLException {
        return new LineString(token, haveM);
    }

    @Override
    protected Geometry[] createSubGeomArray(int nlines) {
        return new LineString[nlines];
    }

    public int numLines() {
        return this.subgeoms.length;
    }

    public LineString[] getLines() {
        return (LineString[])this.subgeoms.clone();
    }

    public LineString getLine(int idx) {
        if (idx >= 0 & idx < this.subgeoms.length) {
            return (LineString)this.subgeoms[idx];
        }
        return null;
    }

    public double length() {
        if (this.len < 0.0) {
            LineString[] lines = (LineString[])this.subgeoms;
            if (lines.length < 1) {
                this.len = 0.0;
            } else {
                double sum = 0.0;
                for (int i2 = 0; i2 < lines.length; ++i2) {
                    sum += lines[i2].length();
                }
                this.len = sum;
            }
        }
        return this.len;
    }
}

